/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.jdk;

import java.io.IOException;
import java.net.Proxy;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.net.url.UrlBuilder;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.client.cookie.GlobalCookieManager;
import org.dromara.hutool.http.client.engine.ClientEngine;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpConnection;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpResponse;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.meta.HttpStatus;
import org.dromara.hutool.http.meta.Method;

public class JdkClientEngine
implements ClientEngine {
    private ClientConfig config;
    private JdkHttpConnection conn;
    private int redirectCount;

    @Override
    public JdkClientEngine init(ClientConfig config) {
        this.config = config;
        if (null != this.conn) {
            this.conn.disconnectQuietly();
            this.conn = null;
        }
        return this;
    }

    @Override
    public Response send(Request message) {
        return this.send(message, true);
    }

    public JdkHttpResponse send(Request message, boolean isAsync) {
        this.initConn(message);
        try {
            this.doSend(message);
        }
        catch (IOException e) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this});
            throw new RuntimeException(e);
        }
        return this.sendRedirectIfPossible(message, isAsync);
    }

    @Override
    public Object getRawEngine() {
        return this;
    }

    @Override
    public void close() {
        if (null != this.conn) {
            this.conn.disconnectQuietly();
        }
    }

    private void doSend(Request message) throws IOException {
        HttpBody body = message.body();
        if (null != body) {
            body.writeClose(this.conn.getOutputStream());
            return;
        }
        this.conn.connect();
    }

    private void initConn(Request message) {
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this});
        this.conn = this.buildConn(message);
    }

    private JdkHttpConnection buildConn(Request message) {
        ClientConfig config = (ClientConfig)ObjUtil.defaultIfNull((Object)this.config, ClientConfig::of);
        JdkHttpConnection conn = (JdkHttpConnection)JdkHttpConnection.of(message.url().toURL(), (Proxy)config.getProxy()).setConnectTimeout(config.getConnectionTimeout()).setReadTimeout(config.getReadTimeout()).setMethod(message.method()).setSSLInfo(config.getSslInfo()).setInstanceFollowRedirects(false).setChunkedStreamingMode(message.isChunked() ? 4096 : -1).setDisableCache(config.isDisableCache()).header(message.headers(), true);
        if (null == message.header(HeaderName.COOKIE)) {
            GlobalCookieManager.add(conn);
        }
        return conn;
    }

    private JdkHttpResponse sendRedirectIfPossible(Request message, boolean isAsync) {
        JdkHttpConnection conn = this.conn;
        if (message.maxRedirectCount() > 0) {
            int code;
            try {
                code = conn.getCode();
            }
            catch (IOException e) {
                conn.disconnectQuietly();
                throw new HttpException(e);
            }
            if (code != 200 && HttpStatus.isRedirected(code)) {
                message.url(JdkClientEngine.getLocationUrl(message.url(), conn.header(HeaderName.LOCATION)));
                if (this.redirectCount < message.maxRedirectCount()) {
                    ++this.redirectCount;
                    return this.send(message, isAsync);
                }
            }
        }
        return new JdkHttpResponse(this.conn, true, message.charset(), isAsync, JdkClientEngine.isIgnoreResponseBody(message.method()));
    }

    private static UrlBuilder getLocationUrl(UrlBuilder parentUrl, String location) {
        UrlBuilder redirectUrl;
        if (!HttpUtil.isHttp(location) && !HttpUtil.isHttps(location)) {
            if (!location.startsWith("/")) {
                location = StrUtil.addSuffixIfNot((CharSequence)parentUrl.getPathStr(), (CharSequence)"/") + location;
            }
            redirectUrl = UrlBuilder.of((String)parentUrl.getScheme(), (String)parentUrl.getHost(), (int)parentUrl.getPort(), (String)location, null, null, (Charset)parentUrl.getCharset());
        } else {
            redirectUrl = UrlBuilder.ofHttpWithoutEncode((String)location);
        }
        return redirectUrl;
    }

    private static boolean isIgnoreResponseBody(Method method) {
        return Method.HEAD == method || Method.CONNECT == method || Method.OPTIONS == method || Method.TRACE == method;
    }
}

