/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.jwt;

import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.exception.ValidateException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.jwt.JWTException;
import org.dromara.hutool.json.jwt.JWTHeader;
import org.dromara.hutool.json.jwt.JWTPayload;
import org.dromara.hutool.json.jwt.JWTValidator;
import org.dromara.hutool.json.jwt.RegisteredPayload;
import org.dromara.hutool.json.jwt.signers.AlgorithmUtil;
import org.dromara.hutool.json.jwt.signers.JWTSigner;
import org.dromara.hutool.json.jwt.signers.JWTSignerUtil;
import org.dromara.hutool.json.jwt.signers.NoneJWTSigner;

public class JWT
implements RegisteredPayload<JWT> {
    private final JWTHeader header = new JWTHeader();
    private final JWTPayload payload = new JWTPayload();
    private Charset charset = CharsetUtil.UTF_8;
    private JWTSigner signer;
    private List<String> tokens;

    public static JWT of() {
        return new JWT();
    }

    public static JWT of(String token) {
        return new JWT(token);
    }

    public JWT() {
    }

    public JWT(String token) {
        this();
        this.parse(token);
    }

    public JWT parse(String token) throws IllegalArgumentException {
        Assert.notBlank((CharSequence)token, (String)"Token String must be not blank!", (Object[])new Object[0]);
        List<String> tokens = JWT.splitToken(token);
        this.tokens = tokens;
        this.header.parse(tokens.get(0), this.charset);
        this.payload.parse(tokens.get(1), this.charset);
        return this;
    }

    public JWT setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public JWT setKey(byte[] key) {
        String algorithmId = (String)this.header.getClaim(JWTHeader.ALGORITHM);
        if (StrUtil.isNotBlank((CharSequence)algorithmId)) {
            return this.setSigner(algorithmId, key);
        }
        return this.setSigner(JWTSignerUtil.hs256(key));
    }

    public JWT setSigner(String algorithmId, byte[] key) {
        return this.setSigner(JWTSignerUtil.createSigner(algorithmId, key));
    }

    public JWT setSigner(String algorithmId, Key key) {
        return this.setSigner(JWTSignerUtil.createSigner(algorithmId, key));
    }

    public JWT setSigner(String algorithmId, KeyPair keyPair) {
        return this.setSigner(JWTSignerUtil.createSigner(algorithmId, keyPair));
    }

    public JWT setSigner(JWTSigner signer) {
        this.signer = signer;
        return this;
    }

    public JWTSigner getSigner() {
        return this.signer;
    }

    public JSONObject getHeaders() {
        return this.header.getClaimsJson();
    }

    public JWTHeader getHeader() {
        return this.header;
    }

    public Object getHeader(String name) {
        return this.header.getClaim(name);
    }

    public String getAlgorithm() {
        return (String)this.header.getClaim(JWTHeader.ALGORITHM);
    }

    public JWT setHeader(String name, Object value) {
        this.header.setClaim(name, value);
        return this;
    }

    public JWT addHeaders(Map<String, ?> headers) {
        this.header.addHeaders(headers);
        return this;
    }

    public JSONObject getPayloads() {
        return this.payload.getClaimsJson();
    }

    public JWTPayload getPayload() {
        return this.payload;
    }

    public Object getPayload(String name) {
        return this.getPayload().getClaim(name);
    }

    public <T> T getPayload(String propertyName, Class<T> propertyType) {
        return (T)this.getPayload().getClaimsJson().get(propertyName, propertyType);
    }

    @Override
    public JWT setPayload(String name, Object value) {
        this.payload.setClaim(name, value);
        return this;
    }

    public JWT addPayloads(Map<String, ?> payloads) {
        this.payload.addPayloads(payloads);
        return this;
    }

    public String sign() {
        return this.sign(this.signer);
    }

    public String sign(JWTSigner signer) {
        Assert.notNull((Object)signer, () -> new JWTException("No Signer provided!"));
        String algorithm = (String)this.header.getClaim(JWTHeader.ALGORITHM);
        if (StrUtil.isBlank((CharSequence)algorithm)) {
            this.header.setAlgorithm(AlgorithmUtil.getId(signer.getAlgorithm()));
        }
        String headerBase64 = Base64.encodeUrlSafe((CharSequence)this.header.toString(), (Charset)this.charset);
        String payloadBase64 = Base64.encodeUrlSafe((CharSequence)this.payload.toString(), (Charset)this.charset);
        String sign = signer.sign(headerBase64, payloadBase64);
        return StrUtil.format((CharSequence)"{}.{}.{}", (Object[])new Object[]{headerBase64, payloadBase64, sign});
    }

    public boolean verify() {
        return this.verify(this.signer);
    }

    public boolean validate(long leeway) {
        if (!this.verify()) {
            return false;
        }
        try {
            JWTValidator.of(this).validateDate((Date)DateUtil.now(), leeway);
        }
        catch (ValidateException e) {
            return false;
        }
        return true;
    }

    public boolean verify(JWTSigner signer) {
        List<String> tokens;
        if (null == signer) {
            signer = NoneJWTSigner.NONE;
        }
        if (CollUtil.isEmpty(tokens = this.tokens)) {
            throw new JWTException("No token to verify!");
        }
        return signer.verify(tokens.get(0), tokens.get(1), tokens.get(2));
    }

    private static List<String> splitToken(String token) {
        List tokens = SplitUtil.split((CharSequence)token, (CharSequence)".");
        if (3 != tokens.size()) {
            throw new JWTException("The token was expected 3 parts, but got {}.", tokens.size());
        }
        return tokens;
    }
}

