/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.writer;

import java.io.IOException;
import java.io.Writer;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Predicate;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.InternalJSONUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.serialize.JSONStringer;
import org.dromara.hutool.json.writer.BooleanValueWriter;
import org.dromara.hutool.json.writer.DateValueWriter;
import org.dromara.hutool.json.writer.JSONStringValueWriter;
import org.dromara.hutool.json.writer.JSONValueWriter;
import org.dromara.hutool.json.writer.NumberValueWriter;

public class JSONWriter
extends Writer {
    private final int indentFactor;
    private final int indent;
    private final Writer writer;
    private final JSONConfig config;
    private boolean needSeparator;
    private boolean arrayMode;

    public static JSONWriter of(Writer writer, int indentFactor, int indent, JSONConfig config) {
        return new JSONWriter(writer, indentFactor, indent, config);
    }

    public JSONWriter(Writer writer, int indentFactor, int indent, JSONConfig config) {
        this.writer = writer;
        this.indentFactor = indentFactor;
        this.indent = indent;
        this.config = (JSONConfig)ObjUtil.defaultIfNull((Object)config, (Object)JSONConfig.of());
    }

    public JSONConfig getConfig() {
        return this.config;
    }

    public JSONWriter beginObj() {
        this.writeRaw('{');
        return this;
    }

    public JSONWriter beginArray() {
        this.writeRaw('[');
        this.arrayMode = true;
        return this;
    }

    public JSONWriter end() {
        this.writeLF().writeSpace(this.indent);
        this.writeRaw(this.arrayMode ? (char)']' : '}');
        this.flush();
        this.arrayMode = false;
        this.needSeparator = true;
        return this;
    }

    public JSONWriter writeField(MutableEntry<Object, Object> pair, Predicate<MutableEntry<Object, Object>> predicate) {
        if (null == pair.getValue() && this.config.isIgnoreNullValue()) {
            return this;
        }
        if (null != predicate && !predicate.test(pair)) {
            return this;
        }
        if (!this.arrayMode) {
            this.writeKey(StrUtil.toString((Object)pair.getKey()));
        }
        return this.writeValueDirect(pair.getValue(), predicate);
    }

    public JSONWriter writeKey(String key) {
        if (this.needSeparator) {
            this.writeRaw(',');
        }
        this.writeLF().writeSpace(this.indentFactor + this.indent);
        return this.writeRaw(InternalJSONUtil.quote(key));
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void writeQuoteStrValue(String csq) {
        InternalJSONUtil.quote(csq, this.writer);
    }

    public void writeSpace(int count) {
        if (this.indentFactor > 0) {
            for (int i = 0; i < count; ++i) {
                this.writeRaw(' ');
            }
        }
    }

    public JSONWriter writeLF() {
        if (this.indentFactor > 0) {
            this.writeRaw('\n');
        }
        return this;
    }

    public JSONWriter writeRaw(String csq) {
        try {
            this.writer.append(csq);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    public JSONWriter writeRaw(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    private JSONWriter writeValueDirect(Object value, Predicate<MutableEntry<Object, Object>> predicate) {
        if (this.arrayMode) {
            if (this.needSeparator) {
                this.writeRaw(',');
            }
            this.writeLF().writeSpace(this.indentFactor + this.indent);
        } else {
            this.writeRaw(':').writeSpace(1);
        }
        this.needSeparator = true;
        return this.writeObjValue(value, predicate);
    }

    private JSONWriter writeObjValue(Object value, Predicate<MutableEntry<Object, Object>> predicate) {
        int indent = this.indentFactor + this.indent;
        JSONValueWriter<Object> valueWriter = InternalJSONUtil.getValueWriter(value);
        if (null != valueWriter) {
            valueWriter.write(this, value);
            return this;
        }
        if (value == null) {
            this.writeRaw("null");
        } else if (value instanceof JSON) {
            ((JSON)value).write(this.writer, this.indentFactor, indent, predicate);
        } else if (value instanceof Number) {
            NumberValueWriter.INSTANCE.write(this, (Number)value);
        } else if (value instanceof Date || value instanceof Calendar || value instanceof TemporalAccessor) {
            DateValueWriter.INSTANCE.write(this, value);
        } else if (value instanceof Boolean) {
            BooleanValueWriter.INSTANCE.write(this, (Boolean)value);
        } else if (value instanceof JSONStringer) {
            JSONStringValueWriter.INSTANCE.write(this, (JSONStringer)value);
        } else {
            this.writeQuoteStrValue(value.toString());
        }
        return this;
    }
}

