/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.jwt;

import java.util.Map;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.json.jwt.JWT;
import org.dromara.hutool.json.jwt.JWTHeader;
import org.dromara.hutool.json.jwt.signers.JWTSigner;

public class JWTUtil {
    public static String createToken(Map<String, Object> payload, byte[] key) {
        return JWTUtil.createToken((Map<String, Object>)MapUtil.of((Object)JWTHeader.TYPE, (Object)"JWT"), payload, key);
    }

    public static String createToken(Map<String, Object> headers, Map<String, Object> payload, byte[] key) {
        return JWT.of().addHeaders(headers).addPayloads(payload).setKey(key).sign();
    }

    public static String createToken(Map<String, Object> payload, JWTSigner signer) {
        return JWTUtil.createToken(null, payload, signer);
    }

    public static String createToken(Map<String, Object> headers, Map<String, Object> payload, JWTSigner signer) {
        return JWT.of().addHeaders(headers).addPayloads(payload).setSigner(signer).sign();
    }

    public static JWT parseToken(String token) {
        return JWT.of(token);
    }

    public static boolean verify(String token, byte[] key) {
        return JWT.of(token).setKey(key).verify();
    }

    public static boolean verify(String token, JWTSigner signer) {
        return JWT.of(token).verify(signer);
    }
}

