/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serialize;

import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.hutool.core.map.concurrent.SafeConcurrentHashMap;
import org.dromara.hutool.core.reflect.NullType;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.serialize.JSONArraySerializer;
import org.dromara.hutool.json.serialize.JSONDeserializer;
import org.dromara.hutool.json.serialize.JSONObjectSerializer;
import org.dromara.hutool.json.serialize.JSONSerializer;
import org.dromara.hutool.json.serialize.TemporalAccessorSerializer;

public class GlobalSerializeMapping {
    private static Map<Type, JSONSerializer<? extends JSON, ?>> serializerMap = new SafeConcurrentHashMap();
    private static Map<Type, JSONDeserializer<?>> deserializerMap = new SafeConcurrentHashMap();

    public static void putSerializer(Type type, JSONArraySerializer<?> serializer) {
        GlobalSerializeMapping.putInternal(type, serializer);
    }

    public static void putSerializer(Type type, JSONObjectSerializer<?> serializer) {
        GlobalSerializeMapping.putInternal(type, serializer);
    }

    public static synchronized void putDeserializer(Type type, JSONDeserializer<?> deserializer) {
        if (null == deserializerMap) {
            deserializerMap = new ConcurrentHashMap();
        }
        deserializerMap.put((Type)ObjUtil.defaultIfNull((Object)type, (Object)NullType.INSTANCE), deserializer);
    }

    public static JSONSerializer<? extends JSON, ?> getSerializer(Type type) {
        if (null == serializerMap) {
            return null;
        }
        return serializerMap.get(ObjUtil.defaultIfNull((Object)type, (Object)NullType.INSTANCE));
    }

    public static JSONDeserializer<?> getDeserializer(Type type) {
        if (null == deserializerMap) {
            return null;
        }
        return deserializerMap.get(ObjUtil.defaultIfNull((Object)type, (Object)NullType.INSTANCE));
    }

    private static synchronized void putInternal(Type type, JSONSerializer<? extends JSON, ?> serializer) {
        if (null == serializerMap) {
            serializerMap = new ConcurrentHashMap();
        }
        serializerMap.put((Type)ObjUtil.defaultIfNull((Object)type, (Object)NullType.INSTANCE), serializer);
    }

    static {
        TemporalAccessorSerializer localDateSerializer = new TemporalAccessorSerializer(LocalDate.class);
        serializerMap.put((Type)((Object)LocalDate.class), localDateSerializer);
        deserializerMap.put((Type)((Object)LocalDate.class), localDateSerializer);
        TemporalAccessorSerializer localDateTimeSerializer = new TemporalAccessorSerializer(LocalDateTime.class);
        serializerMap.put((Type)((Object)LocalDateTime.class), localDateTimeSerializer);
        deserializerMap.put((Type)((Object)LocalDateTime.class), localDateTimeSerializer);
        TemporalAccessorSerializer localTimeSerializer = new TemporalAccessorSerializer(LocalTime.class);
        serializerMap.put((Type)((Object)LocalTime.class), localTimeSerializer);
        deserializerMap.put((Type)((Object)LocalTime.class), localTimeSerializer);
    }
}

