/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import org.dromara.hutool.json.engine.JSONEngine;

public class FastJSON2Engine
implements JSONEngine {
    private final JSONWriter.Context writerContext = JSONFactory.createWriteContext();
    private final JSONReader.Context readerContext = JSONFactory.createReadContext();

    @Override
    public void serialize(Object bean, Writer writer) {
        try (JSONWriter jsonWriter = JSONWriter.of((JSONWriter.Context)this.writerContext);){
            if (bean == null) {
                jsonWriter.writeNull();
            } else {
                jsonWriter.setRootObject(bean);
                Class<?> valueClass = bean.getClass();
                ObjectWriter objectWriter = this.writerContext.getObjectWriter(valueClass, valueClass);
                objectWriter.write(jsonWriter, bean, null, null, 0L);
            }
            jsonWriter.flushTo(writer);
        }
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        ObjectReader objectReader = this.readerContext.getObjectReader((Type)type);
        try (JSONReader jsonReader = JSONReader.of((Reader)reader, (JSONReader.Context)this.readerContext);){
            if (jsonReader.isEnd()) {
                T t = null;
                return t;
            }
            Object object = objectReader.readObject(jsonReader, (Type)type, null, 0L);
            jsonReader.handleResolveTasks(object);
            Object object2 = object;
            return (T)object2;
        }
    }
}

