/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.engine.JSONEngine;

public class JacksonEngine
extends SimpleWrapper<ObjectMapper>
implements JSONEngine {
    public JacksonEngine() {
        super((Object)new ObjectMapper());
        ((ObjectMapper)this.raw).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        ((ObjectMapper)this.raw).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }

    @Override
    public void serialize(Object bean, Writer writer) {
        try {
            ((ObjectMapper)this.raw).writeValue(writer, bean);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        try {
            if (type instanceof Class) {
                return (T)((ObjectMapper)this.raw).readValue(reader, (Class)type);
            }
            if (type instanceof TypeReference) {
                return (T)((ObjectMapper)this.raw).readValue(reader, (TypeReference)type);
            }
            if (type instanceof JavaType) {
                return (T)((ObjectMapper)this.raw).readValue(reader, (JavaType)type);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        throw new JSONException("Unsupported type: {}", type.getClass());
    }
}

