/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.mapper;

import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.serialize.JSONStringer;
import org.dromara.hutool.json.writer.GlobalValueWriters;

public class JSONValueMapper {
    private final JSONConfig jsonConfig;

    public static JSONValueMapper of(JSONConfig jsonConfig) {
        return new JSONValueMapper(jsonConfig);
    }

    public JSONValueMapper(JSONConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
    }

    public Object map(Object object) {
        if (null == object || null != GlobalValueWriters.get(object) || object instanceof JSON || object instanceof JSONStringer || object instanceof CharSequence || ObjUtil.isBasicType((Object)object)) {
            return object;
        }
        try {
            if (object instanceof Iterable || ArrayUtil.isArray((Object)object)) {
                return new JSONArray(object, this.jsonConfig);
            }
            return new JSONObject(object, this.jsonConfig);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

