/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.engine.AbstractJSONEngine;
import org.dromara.hutool.json.engine.JSONEngineConfig;

public class FastJSON2Engine
extends AbstractJSONEngine {
    private JSONReader.Context readerContext;
    private JSONWriter.Context writerContext;

    public FastJSON2Engine() {
        Assert.notNull(JSONFactory.class);
    }

    @Override
    public void serialize(Object bean, Writer writer) {
        this.initEngine();
        try (JSONWriter jsonWriter = JSONWriter.of((JSONWriter.Context)this.writerContext);){
            if (bean == null) {
                jsonWriter.writeNull();
            } else {
                jsonWriter.setRootObject(bean);
                Class<?> valueClass = bean.getClass();
                ObjectWriter objectWriter = this.writerContext.getObjectWriter(valueClass, valueClass);
                objectWriter.write(jsonWriter, bean, null, null, 0L);
            }
            jsonWriter.flushTo(writer);
        }
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        this.initEngine();
        ObjectReader objectReader = this.readerContext.getObjectReader((Type)type);
        try (JSONReader jsonReader = JSONReader.of((Reader)reader, (JSONReader.Context)this.readerContext);){
            if (jsonReader.isEnd()) {
                T t = null;
                return t;
            }
            Object object = objectReader.readObject(jsonReader, (Type)type, null, 0L);
            jsonReader.handleResolveTasks(object);
            Object object2 = object;
            return (T)object2;
        }
    }

    @Override
    protected void reset() {
        this.readerContext = null;
        this.writerContext = null;
    }

    @Override
    protected void initEngine() {
        if (null == this.readerContext) {
            this.readerContext = JSONFactory.createReadContext();
        }
        if (null == this.writerContext) {
            ArrayList features = ListUtil.of((Object[])new JSONWriter.Feature[0]);
            if (((Boolean)ObjUtil.defaultIfNull((Object)this.config, JSONEngineConfig::isPrettyPrint, (Object)false)).booleanValue()) {
                features.add(JSONWriter.Feature.PrettyFormat);
            }
            this.writerContext = JSONFactory.createWriteContext((JSONWriter.Feature[])features.toArray(new JSONWriter.Feature[0]));
        }
    }
}

