/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONUtil;
import org.dromara.hutool.json.engine.AbstractJSONEngine;
import org.dromara.hutool.json.engine.JSONEngineConfig;

public class HutoolJSONEngine
extends AbstractJSONEngine {
    private JSONConfig hutoolSJONConfig;

    @Override
    public void serialize(Object bean, Writer writer) {
        this.initEngine();
        JSON json = (JSON)JSONUtil.parse(bean, this.hutoolSJONConfig);
        json.write(writer, (Boolean)ObjUtil.defaultIfNull((Object)this.config, JSONEngineConfig::isPrettyPrint, (Object)false) != false ? 2 : 0, 0, null);
    }

    @Override
    public <T> T deserialize(Reader reader, Object type) {
        this.initEngine();
        JSON json = (JSON)JSONUtil.parse(reader, this.hutoolSJONConfig);
        return json.toBean((Type)type);
    }

    @Override
    protected void reset() {
        this.hutoolSJONConfig = null;
    }

    @Override
    protected void initEngine() {
        if (null != this.hutoolSJONConfig) {
            return;
        }
        this.hutoolSJONConfig = JSONConfig.of();
    }
}

