/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.ServiceLoader;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.engine.JSONEngine;
import org.dromara.hutool.json.engine.JSONEngineConfig;

public class JSONEngineFactory {
    public static JSONEngine getEngine() {
        return (JSONEngine)Singleton.get((String)JSONEngine.class.getName(), JSONEngineFactory::createEngine);
    }

    public static JSONEngine createEngine(String engineName) throws JSONException {
        if (StrUtil.equalsIgnoreCase((CharSequence)"fastjson", (CharSequence)engineName)) {
            engineName = "FastJSON2";
        }
        if (!StrUtil.endWithIgnoreCase((CharSequence)engineName, (CharSequence)"Engine")) {
            engineName = engineName + "Engine";
        }
        ServiceLoader list = SpiUtil.loadList(JSONEngine.class);
        for (String serviceName : list.getServiceNames()) {
            if (!StrUtil.endWithIgnoreCase((CharSequence)serviceName, (CharSequence)engineName)) continue;
            return (JSONEngine)list.getService(serviceName);
        }
        throw new JSONException("No such engine named: " + engineName);
    }

    public static JSONEngine createEngine(JSONEngineConfig config) {
        return JSONEngineFactory.createEngine().init(config);
    }

    public static JSONEngine createEngine() {
        return (JSONEngine)SpiUtil.loadFirstAvailable(JSONEngine.class);
    }
}

