/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.dromara.hutool.core.bean.path.BeanPath;
import org.dromara.hutool.core.bean.path.NodeBeanFactory;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.reader.JSONParser;
import org.dromara.hutool.json.reader.JSONTokener;
import org.dromara.hutool.json.serializer.JSONMapper;
import org.dromara.hutool.json.serializer.TypeAdapter;
import org.dromara.hutool.json.support.JSONNodeBeanFactory;
import org.dromara.hutool.json.writer.JSONWriter;

public class JSONFactory {
    private final JSONConfig config;
    private final Predicate<MutableEntry<Object, Object>> predicate;
    private volatile JSONMapper mapper;

    public static JSONFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static JSONFactory of(JSONConfig config) {
        return JSONFactory.of(config, null);
    }

    public static JSONFactory of(JSONConfig config, Predicate<MutableEntry<Object, Object>> predicate) {
        return new JSONFactory(config, predicate);
    }

    public JSONFactory(JSONConfig config, Predicate<MutableEntry<Object, Object>> predicate) {
        this.config = (JSONConfig)ObjUtil.defaultIfNull((Object)config, JSONConfig::of);
        this.predicate = predicate;
    }

    public JSONConfig getConfig() {
        return this.config;
    }

    public Predicate<MutableEntry<Object, Object>> getPredicate() {
        return this.predicate;
    }

    public void doPredicate(MutableEntry<Object, Object> entry, Consumer<MutableEntry<Object, Object>> consumer) {
        Predicate<MutableEntry<Object, Object>> predicate = this.predicate;
        if (null != predicate && !predicate.test(entry)) {
            return;
        }
        consumer.accept(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONMapper getMapper() {
        if (null == this.mapper) {
            JSONFactory jSONFactory = this;
            synchronized (jSONFactory) {
                if (null == this.mapper) {
                    this.mapper = JSONMapper.of(this);
                }
            }
        }
        return this.mapper;
    }

    public JSONFactory register(Type type, TypeAdapter typeAdapter) {
        this.getMapper().register(type, typeAdapter);
        return this;
    }

    public JSONFactory register(TypeAdapter typeAdapter) {
        this.getMapper().register(typeAdapter);
        return this;
    }

    public JSONObject ofObj() {
        return new JSONObject(16, this);
    }

    public JSONArray ofArray() {
        return new JSONArray(10, this);
    }

    public JSONPrimitive ofPrimitive(Object value) {
        if (null == value) {
            return null;
        }
        return new JSONPrimitive(value, this);
    }

    public JSONParser ofParser(JSONTokener tokener) {
        return JSONParser.of(tokener, this);
    }

    public JSONWriter ofWriter(Appendable appendable) {
        return this.ofWriter(appendable, 0);
    }

    public JSONWriter ofWriter(Appendable appendable, boolean prettyPrint) {
        return this.ofWriter(appendable, prettyPrint ? 2 : 0);
    }

    public JSONWriter ofWriter(Appendable appendable, int indentFactor) {
        return JSONWriter.of(appendable, indentFactor, this.config, this.predicate);
    }

    public BeanPath<JSON> ofBeanPath(String expression) {
        return BeanPath.of((String)expression, (NodeBeanFactory)new JSONNodeBeanFactory(this.config));
    }

    public JSONObject parseObj(Object obj) {
        return this.getMapper().toJSONObject(obj);
    }

    public JSONArray parseArray(Object obj) {
        return this.getMapper().toJSONArray(obj);
    }

    public JSON parse(Object obj) {
        return this.getMapper().toJSON(obj, true);
    }

    public JSON toJSON(Object obj) {
        return this.getMapper().toJSON(obj, false);
    }

    public <T> T toBean(JSON json, Type type) {
        return this.getMapper().toBean(json, type);
    }

    private static class InstanceHolder {
        public static final JSONFactory INSTANCE = JSONFactory.of(JSONConfig.of(), null);

        private InstanceHolder() {
        }
    }
}

