/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.jwt.signers;

import java.util.HashMap;
import org.dromara.hutool.core.map.BiMap;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.crypto.asymmetric.SignAlgorithm;
import org.dromara.hutool.crypto.digest.mac.HmacAlgorithm;

public class AlgorithmUtil {
    private static final BiMap<String, String> map = new BiMap(new HashMap());

    public static String getAlgorithm(String idOrAlgorithm) {
        return (String)ObjUtil.defaultIfNull((Object)AlgorithmUtil.getAlgorithmById(idOrAlgorithm), (Object)idOrAlgorithm);
    }

    public static String getId(String idOrAlgorithm) {
        return (String)ObjUtil.defaultIfNull((Object)AlgorithmUtil.getIdByAlgorithm(idOrAlgorithm), (Object)idOrAlgorithm);
    }

    private static String getAlgorithmById(String id) {
        return (String)map.get((Object)id.toUpperCase());
    }

    private static String getIdByAlgorithm(String algorithm) {
        return (String)map.getKey((Object)algorithm);
    }

    static {
        map.put((Object)"HS256", (Object)HmacAlgorithm.HmacSHA256.getValue());
        map.put((Object)"HS384", (Object)HmacAlgorithm.HmacSHA384.getValue());
        map.put((Object)"HS512", (Object)HmacAlgorithm.HmacSHA512.getValue());
        map.put((Object)"HMD5", (Object)HmacAlgorithm.HmacMD5.getValue());
        map.put((Object)"HSHA1", (Object)HmacAlgorithm.HmacSHA1.getValue());
        map.put((Object)"SM4CMAC", (Object)HmacAlgorithm.SM4CMAC.getValue());
        map.put((Object)"RS256", (Object)SignAlgorithm.SHA256withRSA.getValue());
        map.put((Object)"RS384", (Object)SignAlgorithm.SHA384withRSA.getValue());
        map.put((Object)"RS512", (Object)SignAlgorithm.SHA512withRSA.getValue());
        map.put((Object)"ES256", (Object)SignAlgorithm.SHA256withECDSA.getValue());
        map.put((Object)"ES384", (Object)SignAlgorithm.SHA384withECDSA.getValue());
        map.put((Object)"ES512", (Object)SignAlgorithm.SHA512withECDSA.getValue());
        map.put((Object)"PS256", (Object)SignAlgorithm.SHA256withRSA_PSS.getValue());
        map.put((Object)"PS384", (Object)SignAlgorithm.SHA384withRSA_PSS.getValue());
        map.put((Object)"PS512", (Object)SignAlgorithm.SHA512withRSA_PSS.getValue());
        map.put((Object)"RMD2", (Object)SignAlgorithm.MD2withRSA.getValue());
        map.put((Object)"RMD5", (Object)SignAlgorithm.MD5withRSA.getValue());
        map.put((Object)"RSHA1", (Object)SignAlgorithm.SHA1withRSA.getValue());
        map.put((Object)"DNONE", (Object)SignAlgorithm.NONEwithDSA.getValue());
        map.put((Object)"DSHA1", (Object)SignAlgorithm.SHA1withDSA.getValue());
        map.put((Object)"ENONE", (Object)SignAlgorithm.NONEwithECDSA.getValue());
        map.put((Object)"ESHA1", (Object)SignAlgorithm.SHA1withECDSA.getValue());
    }
}

