/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Optional;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.reflect.TypeReference;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.JSONDeserializer;
import org.dromara.hutool.json.serializer.JSONSerializer;
import org.dromara.hutool.json.serializer.SimpleJSONContext;
import org.dromara.hutool.json.serializer.TypeAdapter;
import org.dromara.hutool.json.serializer.TypeAdapterManager;
import org.dromara.hutool.json.serializer.impl.CharSequenceTypeAdapter;
import org.dromara.hutool.json.serializer.impl.DefaultDeserializer;

public class JSONMapper
implements Serializable {
    private static final long serialVersionUID = -6714488573738940582L;
    private final JSONFactory factory;
    private volatile TypeAdapterManager typeAdapterManager;

    public static JSONMapper of(JSONFactory factory) {
        return new JSONMapper(factory);
    }

    public JSONMapper(JSONFactory factory) {
        this.factory = factory;
    }

    public TypeAdapterManager getTypeAdapterManager() {
        return this.typeAdapterManager;
    }

    public JSONMapper setTypeAdapterManager(TypeAdapterManager typeAdapterManager) {
        this.typeAdapterManager = typeAdapterManager;
        return this;
    }

    public JSONMapper register(Type type, TypeAdapter typeAdapter) {
        this.initTypeAdapterManager().register(type, typeAdapter);
        return this;
    }

    public JSONMapper register(TypeAdapter typeAdapter) {
        this.initTypeAdapterManager().register(typeAdapter);
        return this;
    }

    public <T> T toBean(JSON json, Type type) {
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        JSONDeserializer<Object> deserializer = this.getDeserializer(json, type);
        try {
            return (T)deserializer.deserialize(json, type);
        }
        catch (Exception e) {
            if (((Boolean)ObjUtil.defaultIfNull((Object)this.factory.getConfig(), JSONConfig::isIgnoreError, (Object)false)).booleanValue()) {
                return null;
            }
            throw e;
        }
    }

    public JSON toJSON(Object obj, boolean parseIfString) {
        return this.mapTo(obj, null, parseIfString);
    }

    public JSONObject toJSONObject(Object obj) {
        return this.mapTo(obj, this.factory.ofObj(), false);
    }

    public JSONArray toJSONArray(Object obj) {
        return this.mapTo(obj, this.factory.ofArray(), false);
    }

    private <T extends JSON> T mapTo(Object obj, T json, boolean parseIfString) {
        JSON result;
        if (null == obj) {
            return null;
        }
        if (obj instanceof Optional ? null == (obj = ((Optional)obj).orElse(null)) : obj instanceof Opt && null == (obj = ((Opt)obj).getOrNull())) {
            return null;
        }
        if (JSONPrimitive.isTypeForJSONPrimitive(obj)) {
            if (null == json) {
                if (parseIfString && obj instanceof String) {
                    return (T)CharSequenceTypeAdapter.INSTANCE.serialize((String)obj, (JSONContext)new SimpleJSONContext(null, this.factory));
                }
                return (T)this.factory.ofPrimitive(obj);
            }
            if (json instanceof JSONPrimitive) {
                return (T)this.factory.ofPrimitive(obj);
            }
        }
        if (obj instanceof JSON) {
            if (null != json) {
                if (obj.getClass() == json.getClass()) {
                    return (T)((JSON)obj);
                }
            } else {
                return (T)((JSON)obj);
            }
        }
        JSONSerializer<Object> serializer = this.getSerializer(obj, obj.getClass());
        boolean ignoreError = (Boolean)ObjUtil.defaultIfNull((Object)this.factory.getConfig(), JSONConfig::isIgnoreError, (Object)false);
        if (null == serializer) {
            if (ignoreError) {
                return null;
            }
            throw new JSONException("No deserializer for type: " + obj.getClass());
        }
        try {
            result = serializer.serialize(obj, new SimpleJSONContext(json, this.factory));
        }
        catch (Exception e) {
            if (ignoreError) {
                return null;
            }
            throw e;
        }
        if (null == json || result.getClass() == json.getClass()) {
            return (T)result;
        }
        if (ignoreError) {
            return null;
        }
        throw new JSONException("JSON type not match, expect: {}, actual: {}", json.getClass().getName(), result.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeAdapterManager initTypeAdapterManager() {
        if (null == this.typeAdapterManager) {
            JSONMapper jSONMapper = this;
            synchronized (jSONMapper) {
                if (null == this.typeAdapterManager) {
                    this.typeAdapterManager = TypeAdapterManager.of();
                }
            }
        }
        return this.typeAdapterManager;
    }

    private JSONSerializer<Object> getSerializer(Object obj, Class<?> clazz) {
        JSONSerializer<Object> serializer = null;
        if (null != this.typeAdapterManager) {
            serializer = this.typeAdapterManager.getSerializer(obj, clazz);
        }
        if (null == serializer) {
            serializer = TypeAdapterManager.getInstance().getSerializer(obj, clazz);
        }
        return serializer;
    }

    private JSONDeserializer<Object> getDeserializer(JSON json, Type type) {
        DefaultDeserializer deserializer = null;
        if (null != this.typeAdapterManager) {
            deserializer = this.typeAdapterManager.getDeserializer(json, type);
        }
        if (null == deserializer) {
            deserializer = TypeAdapterManager.getInstance().getDeserializer(json, type);
        }
        if (null == deserializer) {
            deserializer = DefaultDeserializer.INSTANCE;
        }
        return deserializer;
    }
}

