/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.tuple.Pair;
import org.dromara.hutool.core.lang.tuple.Triple;
import org.dromara.hutool.core.lang.tuple.Tuple;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.serializer.JSONDeserializer;
import org.dromara.hutool.json.serializer.JSONSerializer;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;
import org.dromara.hutool.json.serializer.TypeAdapter;
import org.dromara.hutool.json.serializer.impl.ArrayTypeAdapter;
import org.dromara.hutool.json.serializer.impl.BeanTypeAdapter;
import org.dromara.hutool.json.serializer.impl.CalendarTypeAdapter;
import org.dromara.hutool.json.serializer.impl.CharSequenceTypeAdapter;
import org.dromara.hutool.json.serializer.impl.DateTypeAdapter;
import org.dromara.hutool.json.serializer.impl.EntryTypeAdapter;
import org.dromara.hutool.json.serializer.impl.EnumTypeAdapter;
import org.dromara.hutool.json.serializer.impl.IterTypeAdapter;
import org.dromara.hutool.json.serializer.impl.JSONPrimitiveDeserializer;
import org.dromara.hutool.json.serializer.impl.KBeanDeserializer;
import org.dromara.hutool.json.serializer.impl.MapTypeAdapter;
import org.dromara.hutool.json.serializer.impl.PairDeserializer;
import org.dromara.hutool.json.serializer.impl.RecordDeserializer;
import org.dromara.hutool.json.serializer.impl.ResourceBundleSerializer;
import org.dromara.hutool.json.serializer.impl.ResourceSerializer;
import org.dromara.hutool.json.serializer.impl.TemporalTypeAdapter;
import org.dromara.hutool.json.serializer.impl.ThrowableTypeAdapter;
import org.dromara.hutool.json.serializer.impl.TimeZoneTypeAdapter;
import org.dromara.hutool.json.serializer.impl.TokenerSerializer;
import org.dromara.hutool.json.serializer.impl.TripleDeserializer;
import org.dromara.hutool.json.serializer.impl.TupleDeserializer;

public class TypeAdapterManager {
    private volatile Set<MatcherJSONSerializer<?>> serializerSet;
    private volatile Map<Type, JSONSerializer<?>> serializerMap;
    private volatile Set<MatcherJSONDeserializer<?>> deserializerSet;
    private volatile Map<Type, JSONDeserializer<?>> deserializerMap;

    public static TypeAdapterManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static TypeAdapterManager of() {
        return new TypeAdapterManager();
    }

    public TypeAdapterManager register(TypeAdapter typeAdapter) {
        Assert.notNull((Object)typeAdapter, (String)"typeAdapter must be not null!", (Object[])new Object[0]);
        if (typeAdapter instanceof MatcherJSONSerializer || typeAdapter instanceof MatcherJSONDeserializer) {
            if (typeAdapter instanceof MatcherJSONSerializer) {
                this.getSerializerSet().add((MatcherJSONSerializer)typeAdapter);
            }
            if (typeAdapter instanceof MatcherJSONDeserializer) {
                this.getDeserializerSet().add((MatcherJSONDeserializer)typeAdapter);
            }
            return this;
        }
        throw new JSONException("Adapter: {} is not MatcherJSONSerializer or MatcherJSONDeserializer", typeAdapter.getClass());
    }

    public TypeAdapterManager register(Type type, TypeAdapter typeAdapter) {
        Assert.notNull((Object)type);
        if (typeAdapter instanceof JSONSerializer || typeAdapter instanceof JSONDeserializer) {
            if (typeAdapter instanceof JSONSerializer) {
                this.getSerializerMap().put(type, (JSONSerializer)typeAdapter);
            }
            if (typeAdapter instanceof JSONDeserializer) {
                this.getDeserializerMap().put(type, (JSONDeserializer)typeAdapter);
            }
            return this;
        }
        throw new JSONException("Adapter: {} is not JSONSerializer or JSONDeserializer", typeAdapter.getClass());
    }

    public JSONSerializer<Object> getSerializer(Object bean, Type type) {
        JSONSerializer<Object> result;
        Class rawType = TypeUtil.getClass((Type)type);
        if (null == rawType) {
            return null;
        }
        if (JSONSerializer.class.isAssignableFrom(rawType)) {
            return (JSONSerializer)ConstructorUtil.newInstanceIfPossible((Class)rawType);
        }
        if (MapUtil.isNotEmpty(this.serializerMap) && null != (result = this.serializerMap.get(rawType))) {
            return result;
        }
        if (CollUtil.isNotEmpty(this.serializerSet)) {
            for (MatcherJSONSerializer<Object> matcherJSONSerializer : this.serializerSet) {
                if (!matcherJSONSerializer.match(bean, null)) continue;
                return matcherJSONSerializer;
            }
        }
        return null;
    }

    public JSONDeserializer<Object> getDeserializer(JSON json, Type type) {
        JSONDeserializer<Object> jsonDeserializer;
        Class rawType = TypeUtil.getClass((Type)type);
        if (null == rawType) {
            return null;
        }
        if (JSONDeserializer.class.isAssignableFrom(rawType)) {
            return (JSONDeserializer)ConstructorUtil.newInstanceIfPossible((Class)rawType);
        }
        if (MapUtil.isNotEmpty(this.deserializerMap) && null != (jsonDeserializer = this.deserializerMap.get(rawType))) {
            return jsonDeserializer;
        }
        if (CollUtil.isNotEmpty(this.deserializerSet)) {
            for (MatcherJSONDeserializer<Object> matcherJSONDeserializer : this.deserializerSet) {
                if (!matcherJSONDeserializer.match(json, type)) continue;
                return matcherJSONDeserializer;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MatcherJSONSerializer<?>> getSerializerSet() {
        if (null == this.serializerSet) {
            TypeAdapterManager typeAdapterManager = this;
            synchronized (typeAdapterManager) {
                if (null == this.serializerSet) {
                    this.serializerSet = new LinkedHashSet();
                }
            }
        }
        return this.serializerSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Type, JSONSerializer<?>> getSerializerMap() {
        if (null == this.serializerMap) {
            TypeAdapterManager typeAdapterManager = this;
            synchronized (typeAdapterManager) {
                if (null == this.serializerMap) {
                    this.serializerMap = new HashMap();
                }
            }
        }
        return this.serializerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MatcherJSONDeserializer<?>> getDeserializerSet() {
        if (null == this.deserializerSet) {
            TypeAdapterManager typeAdapterManager = this;
            synchronized (typeAdapterManager) {
                if (null == this.deserializerSet) {
                    this.deserializerSet = new LinkedHashSet();
                }
            }
        }
        return this.deserializerSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Type, JSONDeserializer<?>> getDeserializerMap() {
        if (null == this.deserializerMap) {
            TypeAdapterManager typeAdapterManager = this;
            synchronized (typeAdapterManager) {
                if (null == this.deserializerMap) {
                    this.deserializerMap = new HashMap();
                }
            }
        }
        return this.deserializerMap;
    }

    private static TypeAdapterManager registerDefault(TypeAdapterManager manager) {
        manager.register(ResourceSerializer.INSTANCE);
        manager.register(TokenerSerializer.INSTANCE);
        manager.register(ResourceBundleSerializer.INSTANCE);
        manager.register(JSONPrimitiveDeserializer.INSTANCE);
        manager.register(KBeanDeserializer.INSTANCE);
        manager.register(RecordDeserializer.INSTANCE);
        manager.register((Type)((Object)Triple.class), TripleDeserializer.INSTANCE);
        manager.register((Type)((Object)Pair.class), PairDeserializer.INSTANCE);
        manager.register((Type)((Object)Tuple.class), TupleDeserializer.INSTANCE);
        manager.register(CharSequenceTypeAdapter.INSTANCE);
        manager.register(DateTypeAdapter.INSTANCE);
        manager.register(CalendarTypeAdapter.INSTANCE);
        manager.register(TemporalTypeAdapter.INSTANCE);
        manager.register(TimeZoneTypeAdapter.INSTANCE);
        manager.register(EnumTypeAdapter.INSTANCE);
        manager.register(ThrowableTypeAdapter.INSTANCE);
        manager.register(EntryTypeAdapter.INSTANCE);
        manager.register(MapTypeAdapter.INSTANCE);
        manager.register(IterTypeAdapter.INSTANCE);
        manager.register(ArrayTypeAdapter.INSTANCE);
        manager.register(BeanTypeAdapter.INSTANCE);
        return manager;
    }

    static /* synthetic */ TypeAdapterManager access$000(TypeAdapterManager x0) {
        return TypeAdapterManager.registerDefault(x0);
    }

    private static class SingletonHolder {
        private static final TypeAdapterManager INSTANCE = TypeAdapterManager.access$000(new TypeAdapterManager());

        private SingletonHolder() {
        }
    }
}

