/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.reader.JSONTokener;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;
import org.dromara.hutool.json.xml.JSONXMLParser;
import org.dromara.hutool.json.xml.ParseConfig;

public class CharSequenceTypeAdapter
implements MatcherJSONSerializer<CharSequence>,
MatcherJSONDeserializer<CharSequence> {
    public static final CharSequenceTypeAdapter INSTANCE = new CharSequenceTypeAdapter();

    @Override
    public boolean match(Object bean, JSONContext context) {
        return bean instanceof CharSequence;
    }

    @Override
    public boolean match(JSON json, Type deserializeType) {
        return CharSequence.class.isAssignableFrom(TypeUtil.getClass((Type)deserializeType));
    }

    @Override
    public JSON serialize(CharSequence bean, JSONContext context) {
        String jsonStr = StrUtil.trim((CharSequence)bean);
        if (StrUtil.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        JSON contextJson = context.getContextJson();
        if (contextJson instanceof JSONPrimitive) {
            return context.getOrCreatePrimitive(bean);
        }
        if (StrUtil.startWith((CharSequence)jsonStr, (char)'<')) {
            JSONObject jsonObject = context.getOrCreateObj();
            JSONXMLParser.of(ParseConfig.of(), null).parseJSONObject(jsonStr, jsonObject);
            return jsonObject;
        }
        return context.getFactory().ofParser(new JSONTokener(jsonStr)).parse();
    }

    @Override
    public CharSequence deserialize(JSON json, Type deserializeType) {
        if (json instanceof JSONPrimitive) {
            return ((JSONPrimitive)json).getValue().toString();
        }
        return json.toString();
    }
}

