/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.JSONUtil;
import org.dromara.hutool.json.serializer.JSONDeserializer;

public class DefaultDeserializer
implements JSONDeserializer<Object> {
    public static final DefaultDeserializer INSTANCE = new DefaultDeserializer();

    @Override
    public Object deserialize(JSON json, Type deserializeType) {
        Class rawType = TypeUtil.getClass((Type)deserializeType);
        if (null == rawType || Object.class == rawType || rawType.isAssignableFrom(json.getClass())) {
            if (json instanceof JSONPrimitive) {
                return ((JSONPrimitive)json).getValue();
            }
            return json;
        }
        if (json instanceof JSONPrimitive && JSON.class.isAssignableFrom(rawType)) {
            Object value = json.asJSONPrimitive().getValue();
            if (value instanceof CharSequence) {
                return JSONUtil.parse(value, json.config());
            }
        } else if (json instanceof JSONObject && JSONArray.class == rawType) {
            return JSONUtil.parseArray(json, json.config());
        }
        throw new JSONException("Unsupported type {} to {}", json.getClass(), deserializeType.getTypeName());
    }
}

