/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.support;

import java.util.Map;
import java.util.function.Predicate;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.lang.copier.Copier;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.JSONObject;

public class BeanToJSONCopier
implements Copier<JSONObject> {
    private final Object source;
    private final JSONObject target;
    private final JSONFactory factory;

    public BeanToJSONCopier(Object source, JSONObject target, JSONFactory factory) {
        this.source = source;
        this.target = target;
        this.factory = factory;
    }

    public JSONObject copy() {
        JSONConfig config = this.factory.getConfig();
        Map sourcePropDescMap = BeanUtil.getBeanDesc(this.source.getClass()).getPropMap(config.isIgnoreCase());
        sourcePropDescMap.forEach((sFieldName, sDesc) -> {
            if (null == sFieldName || !sDesc.isReadable(config.isTransientSupport())) {
                return;
            }
            Object sValue = sDesc.getValue(this.source, config.isIgnoreError());
            this.putValue((String)sFieldName, sValue, config.isIgnoreNullValue());
        });
        return this.target;
    }

    private void putValue(String fieldName, Object sValue, boolean ignoreNullValue) {
        Predicate<MutableEntry<Object, Object>> predicate = this.factory.getPredicate();
        if (null != predicate) {
            MutableEntry entry = new MutableEntry((Object)fieldName, sValue);
            if (predicate.test((MutableEntry<Object, Object>)entry)) {
                this.target.putValue((String)entry.getKey(), entry.getValue());
            }
        } else if (null != sValue || !ignoreNullValue) {
            this.target.putValue(fieldName, sValue);
        }
    }
}

