/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Date;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.engine.gson.GsonTypeAdapter;

public class DateGsonTypeAdapter
implements GsonTypeAdapter<Date> {
    public static final DateGsonTypeAdapter INSTANCE = new DateGsonTypeAdapter(null);
    private final String dateFormat;

    public DateGsonTypeAdapter(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        return StrUtil.isEmpty((CharSequence)this.dateFormat) ? new JsonPrimitive((Number)src.getTime()) : new JsonPrimitive(DateUtil.format((Date)src, (String)this.dateFormat));
    }

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return StrUtil.isEmpty((CharSequence)this.dateFormat) ? DateUtil.date((long)json.getAsLong()) : DateUtil.parse((CharSequence)json.getAsString(), (String)this.dateFormat);
    }
}

