/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.engine.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.temporal.TemporalAccessor;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.date.TimeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class JacksonTemporalDeserializer
extends StdDeserializer<TemporalAccessor> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends TemporalAccessor> type;
    private final String dateFormat;

    public JacksonTemporalDeserializer(Class<? extends TemporalAccessor> type, String dateFormat) {
        super(TemporalAccessor.class);
        this.type = type;
        this.dateFormat = dateFormat;
    }

    public TemporalAccessor deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return StrUtil.isEmpty((CharSequence)this.dateFormat) ? (TemporalAccessor)ConvertUtil.convert(this.type, (Object)p.getLongValue()) : (TemporalAccessor)ConvertUtil.convert(this.type, (Object)TimeUtil.parse((CharSequence)p.getValueAsString(), (String)this.dateFormat));
    }
}

