/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.jwt;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONUtil;

public class Claims
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JSONConfig CONFIG = JSONConfig.of().setDateFormat("#sss");
    private JSONObject claimJSON;

    protected void setClaim(String name, Object value) {
        Assert.notNull((Object)name, (String)"Name must be not null!", (Object[])new Object[0]);
        this.init();
        if (value == null) {
            this.claimJSON.remove(name);
            return;
        }
        this.claimJSON.putValue(name, value);
    }

    protected void putAll(Map<String, ?> headerClaims) {
        if (MapUtil.isNotEmpty(headerClaims)) {
            for (Map.Entry<String, ?> entry : headerClaims.entrySet()) {
                this.setClaim(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object getClaim(String name) {
        this.init();
        return this.claimJSON.getObj(name);
    }

    public JSONObject getClaimsJson() {
        this.init();
        return this.claimJSON;
    }

    public void parse(String tokenPart, Charset charset) {
        this.claimJSON = JSONUtil.parseObj(Base64.decodeStr((CharSequence)tokenPart, (Charset)charset), this.CONFIG);
    }

    public String toString() {
        this.init();
        return this.claimJSON.toString();
    }

    private void init() {
        if (null == this.claimJSON) {
            this.claimJSON = new JSONObject(this.CONFIG);
        }
    }
}

