/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.jwt;

import java.util.Date;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.exception.ValidateException;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.jwt.JWT;
import org.dromara.hutool.json.jwt.JWTPayload;
import org.dromara.hutool.json.jwt.signers.JWTSigner;
import org.dromara.hutool.json.jwt.signers.NoneJWTSigner;

public class JWTValidator {
    private final JWT jwt;

    public static JWTValidator of(String token) {
        return new JWTValidator(JWT.of(token));
    }

    public static JWTValidator of(JWT jwt) {
        return new JWTValidator(jwt);
    }

    public JWTValidator(JWT jwt) {
        this.jwt = jwt;
    }

    public JWTValidator validateAlgorithm() throws ValidateException {
        return this.validateAlgorithm(null);
    }

    public JWTValidator validateAlgorithm(JWTSigner signer) throws ValidateException {
        JWTValidator.validateAlgorithm(this.jwt, signer);
        return this;
    }

    public JWTValidator validateDate() throws ValidateException {
        return this.validateDate((Date)DateUtil.beginOfSecond((Date)DateUtil.now()));
    }

    public JWTValidator validateDate(Date dateToCheck) throws ValidateException {
        JWTValidator.validateDate(this.jwt.getPayload(), dateToCheck, 0L);
        return this;
    }

    public JWTValidator validateDate(Date dateToCheck, long leeway) throws ValidateException {
        JWTValidator.validateDate(this.jwt.getPayload(), dateToCheck, leeway);
        return this;
    }

    private static void validateAlgorithm(JWT jwt, JWTSigner signer) throws ValidateException {
        String algorithmId = jwt.getAlgorithm();
        if (null == signer) {
            signer = jwt.getSigner();
        }
        if (StrUtil.isEmpty((CharSequence)algorithmId)) {
            if (null == signer || signer instanceof NoneJWTSigner) {
                return;
            }
            throw new ValidateException("No algorithm defined in header!");
        }
        if (null == signer) {
            throw new IllegalArgumentException("No Signer for validate algorithm!");
        }
        String algorithmIdInSigner = signer.getAlgorithmId();
        if (!StrUtil.equals((CharSequence)algorithmId, (CharSequence)algorithmIdInSigner)) {
            throw new ValidateException("Algorithm [{}] defined in header doesn't match to [{}]!", new Object[]{algorithmId, algorithmIdInSigner});
        }
        if (!jwt.verify(signer)) {
            throw new ValidateException("Signature verification failed!");
        }
    }

    private static void validateDate(JWTPayload payload, Date now, long leeway) throws ValidateException {
        if (null == now) {
            now = DateUtil.now();
            now.setTime(now.getTime() / 1000L * 1000L);
        }
        Date notBefore = payload.getClaimsJson().getDate("nbf");
        JWTValidator.validateNotAfter("nbf", notBefore, now, leeway);
        Date expiresAt = payload.getClaimsJson().getDate("exp");
        JWTValidator.validateNotBefore("exp", expiresAt, now, leeway);
        Date issueAt = payload.getClaimsJson().getDate("iat");
        JWTValidator.validateNotAfter("iat", issueAt, now, leeway);
    }

    private static void validateNotAfter(String fieldName, Date dateToCheck, Date now, long leeway) throws ValidateException {
        if (null == dateToCheck) {
            return;
        }
        if (leeway > 0L) {
            now = DateUtil.date((long)(now.getTime() + leeway * 1000L));
        }
        if (dateToCheck.after(now)) {
            throw new ValidateException("'{}':[{}] is after now:[{}]", new Object[]{fieldName, DateUtil.date((Date)dateToCheck), DateUtil.date((Date)now)});
        }
    }

    private static void validateNotBefore(String fieldName, Date dateToCheck, Date now, long leeway) throws ValidateException {
        if (null == dateToCheck) {
            return;
        }
        if (leeway > 0L) {
            now = DateUtil.date((long)(now.getTime() - leeway * 1000L));
        }
        if (dateToCheck.before(now)) {
            throw new ValidateException("'{}':[{}] is before now:[{}]", new Object[]{fieldName, DateUtil.date((Date)dateToCheck), DateUtil.date((Date)now)});
        }
    }
}

