/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import org.dromara.hutool.core.lang.tuple.Triple;
import org.dromara.hutool.core.reflect.TypeReference;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.serializer.JSONDeserializer;

public class TripleDeserializer
implements JSONDeserializer<Triple<?, ?, ?>> {
    public static final TripleDeserializer INSTANCE = new TripleDeserializer();

    @Override
    public Triple<?, ?, ?> deserialize(JSON json, Type deserializeType) {
        if (deserializeType instanceof TypeReference) {
            deserializeType = ((TypeReference)deserializeType).getType();
        }
        Type leftType = TypeUtil.getTypeArgument((Type)deserializeType, (int)0);
        Type middileType = TypeUtil.getTypeArgument((Type)deserializeType, (int)1);
        Type rightType = TypeUtil.getTypeArgument((Type)deserializeType, (int)2);
        JSONObject jsonObject = json.asJSONObject();
        JSON left = (JSON)jsonObject.get("left");
        JSON middle = (JSON)jsonObject.get("middle");
        JSON right = (JSON)jsonObject.get("right");
        return Triple.of(left.toBean(leftType), middle.toBean(middileType), right.toBean(rightType));
    }
}

