/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.wrapper.Wrapper;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.writer.JSONWriter;

public class JSONPrimitive
implements Wrapper<Object>,
JSON {
    private static final long serialVersionUID = -2026215279191790345L;
    private final JSONFactory factory;
    private Object value;

    public static boolean isTypeForJSONPrimitive(Object value) {
        return value instanceof Boolean || value instanceof Number || value instanceof Character || value instanceof String;
    }

    public static boolean isTypeForJSONPrimitive(Class<?> type) {
        return ClassUtil.isBasicType(type) || Number.class.isAssignableFrom(type) || String.class == type;
    }

    public JSONPrimitive(Object value, JSONConfig config) {
        this(value, JSONFactory.of(config, null));
    }

    public JSONPrimitive(Object value, JSONFactory factory) {
        this.value = Assert.notNull((Object)value);
        this.factory = factory;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getRaw() {
        return this.value;
    }

    public JSONPrimitive setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public JSONFactory getFactory() {
        return this.factory;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public void increment() {
        if (this.value instanceof BigInteger) {
            this.value = ((BigInteger)this.value).add(BigInteger.ONE);
        } else if (this.value instanceof BigDecimal) {
            this.value = ((BigDecimal)this.value).add(BigDecimal.ONE);
        } else if (this.value instanceof Integer) {
            this.value = (Integer)this.value + 1;
        } else if (this.value instanceof Long) {
            this.value = (Long)this.value + 1L;
        } else if (this.value instanceof Double) {
            this.value = (Double)this.value + 1.0;
        } else if (this.value instanceof Float) {
            this.value = Float.valueOf(((Float)this.value).floatValue() + 1.0f);
        } else {
            throw new JSONException("Unable to increment {} type: {}", this.value, this.value.getClass());
        }
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void write(JSONWriter writer) throws JSONException {
        if (this.value instanceof Boolean) {
            writer.writeRaw(this.value.toString());
        } else if (this.value instanceof Number) {
            writer.writeNumber((Number)this.value);
        } else {
            writer.writeQuoteStrValue(this.value.toString());
        }
    }

    public String toString() {
        return this.toJSONString(0);
    }
}

