/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.reader.JSONTokener;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;
import org.dromara.hutool.json.serializer.impl.IterTypeAdapter;

public class ArrayTypeAdapter
implements MatcherJSONSerializer<Object>,
MatcherJSONDeserializer<Object> {
    public static final ArrayTypeAdapter INSTANCE = new ArrayTypeAdapter();

    @Override
    public boolean match(Object bean, JSONContext context) {
        return ArrayUtil.isArray((Object)bean);
    }

    @Override
    public boolean match(JSON json, Type deserializeType) {
        if (json instanceof JSONArray || json instanceof JSONObject) {
            return TypeUtil.getClass((Type)deserializeType).isArray();
        }
        return false;
    }

    @Override
    public JSON serialize(Object bean, JSONContext context) {
        if (bean instanceof byte[]) {
            return this.serializeBytes((byte[])bean, context);
        }
        return IterTypeAdapter.INSTANCE.serialize(new ArrayIter(bean), context);
    }

    @Override
    public Object deserialize(JSON json, Type deserializeType) {
        Class<?> componentType = TypeUtil.getClass((Type)deserializeType).getComponentType();
        return this.deserialize(json, componentType);
    }

    public Object deserialize(JSON json, Class<?> componentType) {
        Object result = Array.newInstance(componentType, json.size());
        if (json instanceof JSONObject) {
            this.fill((JSONObject)json, result, componentType);
        } else {
            this.fill((JSONArray)json, result, componentType);
        }
        return result;
    }

    private JSON serializeBytes(byte[] bytes, JSONContext context) {
        if (ArrayUtil.isNotEmpty((byte[])bytes)) {
            switch (bytes[0]) {
                case 91: 
                case 123: {
                    return context.getFactory().ofParser(new JSONTokener(IoUtil.toStream((byte[])bytes), context.config().isIgnoreZeroWithChar())).parse();
                }
            }
        }
        JSONArray result = context.getOrCreateArray();
        for (byte b : bytes) {
            result.addValue(b);
        }
        return result;
    }

    private void fill(JSONObject json, Object result, Type componentType) {
        int i = 0;
        Iterator iterator = json.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Array.set(result, i, ((JSON)entry.getValue()).toBean(componentType));
            ++i;
        }
    }

    private void fill(JSONArray json, Object result, Type componentType) {
        int i = 0;
        Iterator<JSON> iterator = json.iterator();
        while (iterator.hasNext()) {
            JSON element = iterator.next();
            Array.set(result, i, element.toBean(componentType));
            ++i;
        }
    }
}

