/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import java.util.Date;
import org.dromara.hutool.core.convert.impl.DateConverter;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;

public class DateTypeAdapter
implements MatcherJSONSerializer<Date>,
MatcherJSONDeserializer<Date> {
    public static final DateTypeAdapter INSTANCE = new DateTypeAdapter();

    @Override
    public boolean match(Object bean, JSONContext context) {
        return bean instanceof Date;
    }

    @Override
    public boolean match(JSON json, Type deserializeType) {
        return Date.class.isAssignableFrom(TypeUtil.getClass((Type)deserializeType));
    }

    @Override
    public JSON serialize(Date bean, JSONContext context) {
        JSONConfig config = context.config();
        String format = (String)ObjUtil.apply((Object)config, JSONConfig::getDateFormat);
        Object value = null == format || "#SSS".equals(format) ? Long.valueOf(bean.getTime()) : ("#sss".equals(format) ? Long.valueOf(Math.floorDiv(bean.getTime(), 1000L)) : DateUtil.format((Date)bean, (String)format));
        return new JSONPrimitive(value, config);
    }

    @Override
    public Date deserialize(JSON json, Type deserializeType) {
        JSONConfig config = json.config();
        String format = (String)ObjUtil.apply((Object)config, JSONConfig::getDateFormat);
        return (Date)new DateConverter(format).convert(deserializeType, json.asJSONPrimitive().getValue());
    }
}

