/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.map.MapWrapper;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONDeserializer;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;

public class IterTypeAdapter
implements MatcherJSONSerializer<Object>,
MatcherJSONDeserializer<Object> {
    public static final IterTypeAdapter INSTANCE = new IterTypeAdapter();

    @Override
    public boolean match(Object bean, JSONContext context) {
        if (bean instanceof MapWrapper) {
            return false;
        }
        return bean instanceof Iterable || bean instanceof Iterator;
    }

    @Override
    public boolean match(JSON json, Type deserializeType) {
        if (json instanceof JSONArray || json instanceof JSONObject) {
            Class rawType = TypeUtil.getClass((Type)deserializeType);
            return Collection.class.isAssignableFrom(rawType);
        }
        return false;
    }

    @Override
    public JSON serialize(Object bean, JSONContext context) {
        Iterator iter = bean instanceof Iterator ? (Iterator)bean : ((Iterable)bean).iterator();
        JSONArray json = context.getOrCreateArray();
        IterTypeAdapter.mapFromIterator(bean, iter, json);
        return json;
    }

    @Override
    public Object deserialize(JSON json, Type deserializeType) {
        Class collectionClass = TypeUtil.getClass((Type)deserializeType);
        Type elementType = TypeUtil.getTypeArgument((Type)deserializeType);
        return this.deserialize(json, collectionClass, elementType);
    }

    public Object deserialize(JSON json, Class<?> collectionClass, Type elementType) {
        Collection result = CollUtil.create(collectionClass, (Class)TypeUtil.getClass((Type)elementType));
        if (json instanceof JSONObject) {
            IterTypeAdapter.fill((JSONObject)json, result, elementType);
        } else {
            IterTypeAdapter.fill((JSONArray)json, result, elementType);
        }
        return result;
    }

    static void mapFromIterator(Object source, Iterator<?> iter, JSONArray jsonArray) {
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next == source) continue;
            jsonArray.addValue(next);
        }
    }

    private static void fill(JSONObject json, Collection<?> result, Type elementType) {
        json.forEach((key, value) -> result.add(null == value ? null : (Object)value.toBean(elementType)));
    }

    private static void fill(JSONArray json, Collection<?> result, Type elementType) {
        json.forEach(element -> result.add(null == element ? null : (Object)element.toBean(elementType)));
    }
}

