/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.support;

import org.dromara.hutool.core.text.StrUtil;

public class JSONStrFormatter {
    public static final JSONStrFormatter INSTANCE = new JSONStrFormatter(2, "\n");
    private int indentFactor;
    private CharSequence newLineChars;

    public JSONStrFormatter(int indentFactor, CharSequence newLineChars) {
        this.indentFactor = indentFactor;
        this.newLineChars = newLineChars;
    }

    public JSONStrFormatter setIndentFactor(int indentFactor) {
        this.indentFactor = indentFactor;
        return this;
    }

    public JSONStrFormatter setNewLineChars(CharSequence newLineChars) {
        this.newLineChars = newLineChars;
        return this;
    }

    public String format(String json) {
        StringBuilder result = new StringBuilder();
        Character wrapChar = null;
        boolean isEscapeMode = false;
        int length = json.length();
        int number = 0;
        for (int i = 0; i < length; ++i) {
            char key = json.charAt(i);
            if ('\"' == key || '\'' == key) {
                if (null == wrapChar) {
                    wrapChar = Character.valueOf(key);
                } else if (wrapChar.equals(Character.valueOf(key))) {
                    if (isEscapeMode) {
                        isEscapeMode = false;
                    }
                    wrapChar = null;
                }
                if (i > 1 && json.charAt(i - 1) == ':') {
                    result.append(' ');
                }
                result.append(key);
                continue;
            }
            if ('\\' == key) {
                if (null != wrapChar) {
                    isEscapeMode = !isEscapeMode;
                    result.append(key);
                    continue;
                }
                result.append(key);
            }
            if (null != wrapChar) {
                result.append(key);
                continue;
            }
            if (key == '[' || key == '{') {
                if (i > 1 && json.charAt(i - 1) == ':') {
                    result.append(this.newLineChars).append(this.indent(number));
                }
                result.append(key).append(this.newLineChars);
                result.append(this.indent(++number));
                continue;
            }
            if (key == ']' || key == '}') {
                result.append(this.newLineChars);
                result.append(this.indent(--number));
                result.append(key);
                continue;
            }
            if (key == ',') {
                result.append(key).append(this.newLineChars).append(this.indent(number));
                continue;
            }
            if (i > 1 && json.charAt(i - 1) == ':') {
                result.append(' ');
            }
            result.append(key);
        }
        return result.toString();
    }

    private String indent(int number) {
        return StrUtil.repeat((CharSequence)" ", (int)(number * this.indentFactor));
    }
}

