/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.xml;

import java.util.function.Predicate;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.xml.XmlConstants;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONUtil;
import org.dromara.hutool.json.support.InternalJSONUtil;
import org.dromara.hutool.json.xml.ParseConfig;
import org.dromara.hutool.json.xml.XMLTokener;

public class JSONXMLParser {
    private final ParseConfig parseConfig;
    private final Predicate<MutableEntry<Object, Object>> predicate;

    public static JSONXMLParser of(ParseConfig parseConfig, Predicate<MutableEntry<Object, Object>> predicate) {
        return new JSONXMLParser(parseConfig, predicate);
    }

    public JSONXMLParser(ParseConfig parseConfig, Predicate<MutableEntry<Object, Object>> predicate) {
        this.parseConfig = parseConfig;
        this.predicate = predicate;
    }

    public void parseJSONObject(String xmlStr, JSONObject jo) throws JSONException {
        XMLTokener x = new XMLTokener(xmlStr);
        while (x.more() && x.skipPast("<")) {
            this.parse(x, jo, null, 0);
        }
    }

    private boolean parse(XMLTokener x, JSONObject context, String name, int currentNestingDepth) throws JSONException {
        String string;
        Object token = x.nextToken();
        if (token == XmlConstants.C_BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                token = x.nextToken();
                if ("CDATA".equals(token) && x.next() == '[') {
                    String string2 = x.nextCDATA();
                    if (!string2.isEmpty()) {
                        this.append(context, "content", string2);
                    }
                    return false;
                }
                throw x.syntaxError("Expected 'CDATA['");
            }
            int i = 1;
            do {
                if ((token = x.nextMeta()) == null) {
                    throw x.syntaxError("Missing '>' after '<!'.");
                }
                if (token == XmlConstants.C_LT) {
                    ++i;
                    continue;
                }
                if (token != XmlConstants.C_GT) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (token == XmlConstants.C_QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (token == Character.valueOf('/')) {
            token = x.nextToken();
            if (name == null) {
                throw x.syntaxError("Mismatched close tag " + token);
            }
            if (!token.equals(name)) {
                throw x.syntaxError("Mismatched " + name + " and " + token);
            }
            if (x.nextToken() != XmlConstants.C_GT) {
                throw x.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token instanceof Character) {
            throw x.syntaxError("Misshaped tag");
        }
        String tagName = (String)token;
        token = null;
        JSONObject jsonobject = JSONUtil.ofObj(context.config());
        boolean keepStrings = this.parseConfig.isKeepStrings();
        while (true) {
            if (token == null) {
                token = x.nextToken();
            }
            if (!(token instanceof String)) break;
            string = (String)token;
            token = x.nextToken();
            if (token == Character.valueOf('=')) {
                token = x.nextToken();
                if (!(token instanceof String)) {
                    throw x.syntaxError("Missing value");
                }
                jsonobject.append(string, keepStrings ? token : InternalJSONUtil.parseValueFromString((String)token));
                token = null;
                continue;
            }
            jsonobject.append(string, "");
        }
        if (token == Character.valueOf('/')) {
            if (x.nextToken() != XmlConstants.C_GT) {
                throw x.syntaxError("Misshaped tag");
            }
            if (!jsonobject.isEmpty()) {
                this.append(context, tagName, jsonobject);
            } else {
                this.append(context, tagName, "");
            }
            return false;
        }
        if (token == XmlConstants.C_GT) {
            while (true) {
                if ((token = x.nextContent()) == null) {
                    if (tagName != null) {
                        throw x.syntaxError("Unclosed tag " + tagName);
                    }
                    return false;
                }
                if (token instanceof String) {
                    string = (String)token;
                    if (string.isEmpty()) continue;
                    jsonobject.append("content", keepStrings ? token : InternalJSONUtil.parseValueFromString(string));
                    continue;
                }
                if (token != XmlConstants.C_LT) continue;
                int maxNestingDepth = this.parseConfig.getMaxNestingDepth();
                if (maxNestingDepth > -1 && currentNestingDepth >= maxNestingDepth) {
                    throw x.syntaxError("Maximum nesting depth of " + maxNestingDepth + " reached");
                }
                if (this.parse(x, jsonobject, tagName, currentNestingDepth + 1)) break;
            }
            if (jsonobject.isEmpty()) {
                this.append(context, tagName, "");
            } else if (jsonobject.size() == 1 && jsonobject.get("content") != null) {
                this.append(context, tagName, jsonobject.get("content"));
            } else {
                this.append(context, tagName, jsonobject);
            }
            return false;
        }
        throw x.syntaxError("Misshaped tag");
    }

    private void append(JSONObject jsonObject, String key, Object value) {
        if (null != this.predicate) {
            MutableEntry entry = new MutableEntry((Object)key, value);
            if (this.predicate.test((MutableEntry<Object, Object>)entry)) {
                key = (String)entry.getKey();
                jsonObject.append(key, entry.getValue());
            }
        } else {
            jsonObject.append(key, value);
        }
    }
}

