/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.lang.reflect.Type;
import java.util.List;
import org.dromara.hutool.core.lang.getter.TypeGetter;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.InternalJSONUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONObject;

public interface JSONGetter<K>
extends TypeGetter<K> {
    public JSONConfig config();

    default public boolean isNull(K key) {
        return ObjUtil.isNull((Object)this.getObj(key));
    }

    default public String getStrEscaped(K key) {
        return this.getStrEscaped(key, null);
    }

    default public String getStrEscaped(K key, String defaultValue) {
        return InternalJSONUtil.escape(this.getStr(key, defaultValue));
    }

    default public JSONArray getJSONArray(K key) {
        Object object = this.getObj(key);
        if (ObjUtil.isNull((Object)object)) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONArray)object;
        }
        return new JSONArray(object, this.config());
    }

    default public JSONObject getJSONObject(K key) {
        Object object = this.getObj(key);
        if (ObjUtil.isNull((Object)object)) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONObject)object;
        }
        return new JSONObject(object, this.config());
    }

    default public <T> T getBean(K key, Class<T> beanType) {
        JSONObject obj = this.getJSONObject(key);
        return (T)(null == obj ? null : obj.toBean(beanType));
    }

    default public <T> List<T> getBeanList(K key, Class<T> beanType) {
        JSONArray jsonArray = this.getJSONArray(key);
        return null == jsonArray ? null : jsonArray.toList(beanType);
    }

    default public <T> T get(K key, Type type, T defaultValue) {
        Object value = this.getObj(key);
        if (ObjUtil.isNull((Object)value)) {
            return defaultValue;
        }
        return (T)this.get(key, type, this.config().getConverter(), defaultValue);
    }
}

