/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.xml;

import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.xml.JSONXMLParser;
import org.dromara.hutool.json.xml.JSONXMLSerializer;

public class JSONXMLUtil {
    public static final Character AMP = Character.valueOf('&');
    public static final Character APOS = Character.valueOf('\'');
    public static final Character BANG = Character.valueOf('!');
    public static final Character EQ = Character.valueOf('=');
    public static final Character GT = Character.valueOf('>');
    public static final Character LT = Character.valueOf('<');
    public static final Character QUEST = Character.valueOf('?');
    public static final Character QUOT = Character.valueOf('\"');
    public static final Character SLASH = Character.valueOf('/');

    public static JSONObject toJSONObject(String string) throws JSONException {
        return JSONXMLUtil.toJSONObject(string, false);
    }

    public static JSONObject toJSONObject(String string, boolean keepStrings) throws JSONException {
        return JSONXMLUtil.toJSONObject(new JSONObject(), string, keepStrings);
    }

    public static JSONObject toJSONObject(JSONObject jo, String xmlStr, boolean keepStrings) throws JSONException {
        JSONXMLParser.parseJSONObject(jo, xmlStr, keepStrings);
        return jo;
    }

    public static String toXml(Object object) throws JSONException {
        return JSONXMLUtil.toXml(object, null);
    }

    public static String toXml(Object object, String tagName) throws JSONException {
        return JSONXMLUtil.toXml(object, tagName, "content");
    }

    public static String toXml(Object object, String tagName, String ... contentKeys) throws JSONException {
        return JSONXMLSerializer.toXml(object, tagName, contentKeys);
    }
}

