/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.func.LambdaInfo;
import org.dromara.hutool.core.func.LambdaUtil;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.map.MapWrapper;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.InternalJSONUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONGetter;
import org.dromara.hutool.json.JSONUtil;
import org.dromara.hutool.json.mapper.JSONObjectMapper;
import org.dromara.hutool.json.writer.JSONWriter;

public class JSONObject
extends MapWrapper<String, Object>
implements JSON,
JSONGetter<String> {
    private static final long serialVersionUID = -330220388580734346L;
    public static final int DEFAULT_CAPACITY = 16;
    private JSONConfig config;

    public JSONObject() {
        this(JSONConfig.of());
    }

    public JSONObject(JSONConfig config) {
        this(16, config);
    }

    public JSONObject(int capacity, JSONConfig config) {
        super(InternalJSONUtil.createRawMap(capacity, (JSONConfig)ObjUtil.defaultIfNull((Object)config, (Object)JSONConfig.of())));
        this.config = (JSONConfig)ObjUtil.defaultIfNull((Object)config, (Object)JSONConfig.of());
    }

    public JSONObject(Object source) {
        this(source, JSONConfig.of().setIgnoreNullValue(InternalJSONUtil.defaultIgnoreNullValue(source)));
    }

    public JSONObject(Object source, JSONConfig config) {
        this(source, config, null);
    }

    public JSONObject(Object source, JSONConfig config, Predicate<MutableEntry<String, Object>> predicate) {
        this(16, config);
        JSONObjectMapper.of(source, predicate).mapTo(this);
    }

    @Override
    public JSONConfig config() {
        return this.config;
    }

    public JSONObject setDateFormat(String format) {
        this.config.setDateFormat(format);
        return this;
    }

    public JSONArray toJSONArray(Collection<String> names) throws JSONException {
        if (CollUtil.isEmpty(names)) {
            return null;
        }
        JSONArray ja = new JSONArray(this.config);
        for (String name : names) {
            Object value = this.get(name);
            if (null == value) continue;
            ja.set(value);
        }
        return ja;
    }

    public Object getObj(String key, Object defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public <P, T> T get(SerFunction<P, T> func) {
        LambdaInfo lambdaInfo = LambdaUtil.resolve(func);
        return (T)this.get(lambdaInfo.getFieldName(), lambdaInfo.getReturnType());
    }

    public Object put(String key, Object value) throws JSONException {
        return this.put(key, value, null, this.config().isCheckDuplicate());
    }

    public JSONObject set(String key, Object value) throws JSONException {
        this.set(key, value, null);
        return this;
    }

    public JSONObject setFields(SerSupplier<?> ... fields) {
        Arrays.stream(fields).forEach(f -> this.set(LambdaUtil.getFieldName((Serializable)f), f.get()));
        return this;
    }

    public JSONObject set(String key, Object value, Predicate<MutableEntry<String, Object>> predicate) throws JSONException {
        this.put(key, value, predicate, this.config().isCheckDuplicate());
        return this;
    }

    public JSONObject set(String key, Object value, Predicate<MutableEntry<String, Object>> predicate, boolean checkDuplicate) throws JSONException {
        this.put(key, value, predicate, checkDuplicate);
        return this;
    }

    public JSONObject setOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.set(key, value);
        }
        return this;
    }

    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public JSONObject append(String key, Object value) throws JSONException {
        Object object = this.getObj(key);
        if (object == null) {
            this.set(key, value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).set(value);
        } else {
            this.set(key, JSONUtil.ofArray(this.config).set(object).set(value));
        }
        return this;
    }

    public JSONObject increment(String key) throws JSONException {
        Object value = this.getObj(key);
        if (value == null) {
            this.set(key, 1);
        } else if (value instanceof BigInteger) {
            this.set(key, ((BigInteger)value).add(BigInteger.ONE));
        } else if (value instanceof BigDecimal) {
            this.set(key, ((BigDecimal)value).add(BigDecimal.ONE));
        } else if (value instanceof Integer) {
            this.set(key, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.set(key, (Long)value + 1L);
        } else if (value instanceof Double) {
            this.set(key, (Double)value + 1.0);
        } else if (value instanceof Float) {
            this.set(key, Float.valueOf(((Float)value).floatValue() + 1.0f));
        } else {
            throw new JSONException("Unable to increment [" + InternalJSONUtil.quote(key) + "].");
        }
        return this;
    }

    public String toString() {
        return this.toJSONString(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJSONString(int indentFactor, Predicate<MutableEntry<Object, Object>> predicate) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            return this.write(sw, indentFactor, 0, predicate).toString();
        }
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent, Predicate<MutableEntry<Object, Object>> predicate) throws JSONException {
        JSONWriter jsonWriter = JSONWriter.of(writer, indentFactor, indent, this.config).beginObj();
        this.forEach((key, value) -> jsonWriter.writeField((MutableEntry<Object, Object>)new MutableEntry(key, value), predicate));
        jsonWriter.end();
        return writer;
    }

    public JSONObject clone() throws CloneNotSupportedException {
        JSONObject clone = (JSONObject)super.clone();
        clone.config = this.config;
        return clone;
    }

    private Object put(String key, Object value, Predicate<MutableEntry<String, Object>> predicate, boolean checkDuplicate) throws JSONException {
        if (null == key) {
            return null;
        }
        if (null != predicate) {
            MutableEntry pair = new MutableEntry((Object)key, value);
            if (predicate.test((MutableEntry<String, Object>)pair)) {
                key = (String)pair.getKey();
                value = pair.getValue();
            } else {
                return null;
            }
        }
        boolean ignoreNullValue = this.config.isIgnoreNullValue();
        if (null == value && ignoreNullValue) {
            return this.remove(key);
        }
        if (checkDuplicate && this.containsKey(key)) {
            throw new JSONException("Duplicate key \"{}\"", key);
        }
        return super.put((Object)key, InternalJSONUtil.wrap(value, this.config));
    }
}

