/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.mapper;

import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.RecordUtil;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.InternalJSONUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONParser;
import org.dromara.hutool.json.JSONTokener;
import org.dromara.hutool.json.serialize.GlobalSerializeMapping;
import org.dromara.hutool.json.serialize.JSONSerializer;
import org.dromara.hutool.json.xml.JSONXMLUtil;

public class JSONObjectMapper {
    private final Object source;
    private final Predicate<MutableEntry<String, Object>> predicate;

    public static JSONObjectMapper of(Object source, Predicate<MutableEntry<String, Object>> predicate) {
        return new JSONObjectMapper(source, predicate);
    }

    public JSONObjectMapper(Object source, Predicate<MutableEntry<String, Object>> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    public void mapTo(JSONObject jsonObject) {
        Object source = this.source;
        if (null == source) {
            return;
        }
        JSONSerializer<JSON, ?> serializer = GlobalSerializeMapping.getSerializer(source.getClass());
        if (null != serializer) {
            serializer.serialize(jsonObject, source);
            return;
        }
        if (source instanceof JSONArray) {
            throw new JSONException("Unsupported type [{}] to JSONObject!", source.getClass());
        }
        if (source instanceof JSONTokener) {
            this.mapFromTokener((JSONTokener)((Object)source), jsonObject);
        } else if (source instanceof Map) {
            for (Map.Entry e : ((Map)source).entrySet()) {
                jsonObject.set(Convert.toStr(e.getKey()), e.getValue(), this.predicate, false);
            }
        } else if (source instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)source;
            jsonObject.set(Convert.toStr(entry.getKey()), entry.getValue(), this.predicate, false);
        } else if (source instanceof CharSequence) {
            this.mapFromStr((CharSequence)source, jsonObject);
        } else if (source instanceof Reader) {
            this.mapFromTokener(new JSONTokener((Reader)source, jsonObject.config()), jsonObject);
        } else if (source instanceof InputStream) {
            this.mapFromTokener(new JSONTokener((InputStream)source, jsonObject.config()), jsonObject);
        } else if (source instanceof byte[]) {
            this.mapFromTokener(new JSONTokener(IoUtil.toStream((byte[])((byte[])source)), jsonObject.config()), jsonObject);
        } else if (source instanceof ResourceBundle) {
            this.mapFromResourceBundle((ResourceBundle)source, jsonObject);
        } else if (RecordUtil.isRecord(source.getClass())) {
            this.mapFromRecord(source, jsonObject);
        } else if (BeanUtil.isReadableBean(source.getClass())) {
            this.mapFromBean(source, jsonObject);
        } else if (!jsonObject.config().isIgnoreError()) {
            throw new JSONException("Unsupported type [{}] to JSONObject!", source.getClass());
        }
    }

    private void mapFromResourceBundle(ResourceBundle bundle, JSONObject jsonObject) {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            InternalJSONUtil.propertyPut(jsonObject, key, bundle.getString(key), this.predicate);
        }
    }

    private void mapFromStr(CharSequence source, JSONObject jsonObject) {
        String jsonStr = StrUtil.trim((CharSequence)source);
        if (StrUtil.startWith((CharSequence)jsonStr, (char)'<')) {
            JSONXMLUtil.toJSONObject(jsonObject, jsonStr, false);
            return;
        }
        this.mapFromTokener(new JSONTokener(StrUtil.trim((CharSequence)source), jsonObject.config()), jsonObject);
    }

    private void mapFromTokener(JSONTokener x, JSONObject jsonObject) {
        JSONParser.of(x).parseTo(jsonObject, this.predicate);
    }

    private void mapFromRecord(Object record, JSONObject jsonObject) {
        Map.Entry[] components;
        for (Map.Entry entry : components = RecordUtil.getRecordComponents(record.getClass())) {
            String key = (String)entry.getKey();
            jsonObject.set(key, MethodUtil.invoke((Object)record, (String)key, (Object[])new Object[0]));
        }
    }

    private void mapFromBean(Object bean, JSONObject jsonObject) {
        CopyOptions copyOptions = InternalJSONUtil.toCopyOptions(jsonObject.config());
        if (null != this.predicate) {
            copyOptions.setFieldEditor(entry -> this.predicate.test((MutableEntry<String, Object>)entry) ? entry : null);
        }
        BeanUtil.beanToMap((Object)bean, (Map)((Object)jsonObject), (CopyOptions)copyOptions);
    }
}

