/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import org.dromara.hutool.core.text.StrUtil;

public class JSONStrFormatter {
    private static final String SPACE = "    ";
    private static final char NEW_LINE = '\n';

    public static String format(String json) {
        StringBuilder result = new StringBuilder();
        Character wrapChar = null;
        boolean isEscapeMode = false;
        int length = json.length();
        int number = 0;
        for (int i = 0; i < length; ++i) {
            char key = json.charAt(i);
            if ('\"' == key || '\'' == key) {
                if (null == wrapChar) {
                    wrapChar = Character.valueOf(key);
                } else if (wrapChar.equals(Character.valueOf(key))) {
                    if (isEscapeMode) {
                        isEscapeMode = false;
                    }
                    wrapChar = null;
                }
                if (i > 1 && json.charAt(i - 1) == ':') {
                    result.append(' ');
                }
                result.append(key);
                continue;
            }
            if ('\\' == key) {
                if (null != wrapChar) {
                    isEscapeMode = !isEscapeMode;
                    result.append(key);
                    continue;
                }
                result.append(key);
            }
            if (null != wrapChar) {
                result.append(key);
                continue;
            }
            if (key == '[' || key == '{') {
                if (i > 1 && json.charAt(i - 1) == ':') {
                    result.append('\n');
                    result.append(JSONStrFormatter.indent(number));
                }
                result.append(key);
                result.append('\n');
                result.append(JSONStrFormatter.indent(++number));
                continue;
            }
            if (key == ']' || key == '}') {
                result.append('\n');
                result.append(JSONStrFormatter.indent(--number));
                result.append(key);
                continue;
            }
            if (key == ',') {
                result.append(key);
                result.append('\n');
                result.append(JSONStrFormatter.indent(number));
                continue;
            }
            if (i > 1 && json.charAt(i - 1) == ':') {
                result.append(' ');
            }
            result.append(key);
        }
        return result.toString();
    }

    private static String indent(int number) {
        return StrUtil.repeat((CharSequence)SPACE, (int)number);
    }
}

