/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.mapper;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.InternalJSONUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.serialize.JSONStringer;

public class JSONValueMapper {
    private final JSONConfig jsonConfig;

    public static JSONValueMapper of(JSONConfig jsonConfig) {
        return new JSONValueMapper(jsonConfig);
    }

    public static Object toJsonValue(String string) {
        if (StrUtil.isEmpty((CharSequence)string) || "null".equalsIgnoreCase(string)) {
            return null;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (StrUtil.containsAnyIgnoreCase((CharSequence)string, (CharSequence[])new CharSequence[]{".", "e"})) {
                    return new BigDecimal(string);
                }
                long myLong = Long.parseLong(string);
                if (string.equals(Long.toString(myLong))) {
                    if (myLong == (long)((int)myLong)) {
                        return (int)myLong;
                    }
                    return myLong;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public JSONValueMapper(JSONConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
    }

    public Object map(Object object) {
        if (null == object || null != InternalJSONUtil.getValueWriter(object) || object instanceof JSON || object instanceof JSONStringer || object instanceof CharSequence || ObjUtil.isBasicType((Object)object)) {
            return object;
        }
        if (object instanceof Number) {
            if (!NumberUtil.isValidNumber((Number)((Number)object))) {
                throw new JSONException("JSON does not allow non-finite numbers.");
            }
            return object;
        }
        if (object instanceof Date || object instanceof Calendar || object instanceof TemporalAccessor) {
            return object;
        }
        try {
            if (object instanceof SQLException) {
                return object.toString();
            }
            if (object instanceof Iterable || ArrayUtil.isArray((Object)object)) {
                return new JSONArray(object, this.jsonConfig);
            }
            if (object instanceof Map || object instanceof Map.Entry) {
                return new JSONObject(object, this.jsonConfig);
            }
            if (object instanceof Enum || ClassUtil.isJdkClass(object.getClass())) {
                return object.toString();
            }
            return new JSONObject(object, this.jsonConfig);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

