/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel;

import java.io.File;
import java.io.InputStream;
import org.dromara.hutool.core.exception.DependencyException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.poi.excel.BigExcelWriter;
import org.dromara.hutool.poi.excel.ExcelFileUtil;
import org.dromara.hutool.poi.excel.ExcelReader;
import org.dromara.hutool.poi.excel.ExcelWriter;
import org.dromara.hutool.poi.excel.cell.CellLocation;
import org.dromara.hutool.poi.excel.cell.CellLocationUtil;
import org.dromara.hutool.poi.excel.sax.ExcelSaxReader;
import org.dromara.hutool.poi.excel.sax.ExcelSaxUtil;
import org.dromara.hutool.poi.excel.sax.handler.RowHandler;

public class ExcelUtil {
    public static final String XLS_CONTENT_TYPE = "application/vnd.ms-excel";
    public static final String XLSX_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

    public static void readBySax(String path, int rid, RowHandler rowHandler) {
        ExcelUtil.readBySax(FileUtil.file((String)path), rid, rowHandler);
    }

    public static void readBySax(String path, String idOrRid, RowHandler rowHandler) {
        ExcelUtil.readBySax(FileUtil.file((String)path), idOrRid, rowHandler);
    }

    public static void readBySax(File file, int rid, RowHandler rowHandler) {
        ExcelSaxReader<?> reader = ExcelSaxUtil.createSaxReader(ExcelFileUtil.isXlsx(file), rowHandler);
        reader.read(file, rid);
    }

    public static void readBySax(File file, String idOrRidOrSheetName, RowHandler rowHandler) {
        ExcelSaxReader<?> reader = ExcelSaxUtil.createSaxReader(ExcelFileUtil.isXlsx(file), rowHandler);
        reader.read(file, idOrRidOrSheetName);
    }

    public static void readBySax(InputStream in, int rid, RowHandler rowHandler) {
        in = IoUtil.toMarkSupport((InputStream)in);
        ExcelSaxReader<?> reader = ExcelSaxUtil.createSaxReader(ExcelFileUtil.isXlsx(in), rowHandler);
        reader.read(in, rid);
    }

    public static void readBySax(InputStream in, String idOrRidOrSheetName, RowHandler rowHandler) {
        in = IoUtil.toMarkSupport((InputStream)in);
        ExcelSaxReader<?> reader = ExcelSaxUtil.createSaxReader(ExcelFileUtil.isXlsx(in), rowHandler);
        reader.read(in, idOrRidOrSheetName);
    }

    public static ExcelReader getReader(String bookFilePath) {
        return ExcelUtil.getReader(bookFilePath, 0);
    }

    public static ExcelReader getReader(File bookFile) {
        return ExcelUtil.getReader(bookFile, 0);
    }

    public static ExcelReader getReader(String bookFilePath, int sheetIndex) {
        try {
            return new ExcelReader(bookFilePath, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelReader getReader(String bookFilePath, String sheetName) {
        try {
            return new ExcelReader(bookFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelReader getReader(File bookFile, int sheetIndex) {
        try {
            return new ExcelReader(bookFile, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelReader getReader(File bookFile, String sheetName) {
        try {
            return new ExcelReader(bookFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelReader getReader(InputStream bookStream) {
        return ExcelUtil.getReader(bookStream, 0);
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex) {
        try {
            return new ExcelReader(bookStream, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName) {
        try {
            return new ExcelReader(bookStream, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelWriter getWriter() {
        try {
            return new ExcelWriter();
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelWriter getWriter(boolean isXlsx) {
        try {
            return new ExcelWriter(isXlsx);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelWriter getWriter(String destFilePath) {
        try {
            return new ExcelWriter(destFilePath);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelWriter getWriterWithSheet(String sheetName) {
        try {
            return new ExcelWriter((File)null, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelWriter getWriter(File destFile) {
        try {
            return new ExcelWriter(destFile);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelWriter getWriter(String destFilePath, String sheetName) {
        try {
            return new ExcelWriter(destFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static ExcelWriter getWriter(File destFile, String sheetName) {
        try {
            return new ExcelWriter(destFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter() {
        try {
            return new BigExcelWriter();
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter(int rowAccessWindowSize) {
        try {
            return new BigExcelWriter(rowAccessWindowSize);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter(String destFilePath) {
        try {
            return new BigExcelWriter(destFilePath);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter(File destFile) {
        try {
            return new BigExcelWriter(destFile);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter(String destFilePath, String sheetName) {
        try {
            return new BigExcelWriter(destFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter(File destFile, String sheetName) {
        try {
            return new BigExcelWriter(destFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)ObjUtil.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2", new Object[0]);
        }
    }

    public static String indexToColName(int index) {
        return CellLocationUtil.indexToColName(index);
    }

    public static int colNameToIndex(String colName) {
        return CellLocationUtil.colNameToIndex(colName);
    }

    public static CellLocation toLocation(String locationRef) {
        return CellLocationUtil.toLocation(locationRef);
    }
}

