/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.iter.IterUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.poi.excel.reader.AbstractSheetReader;

public class MapSheetReader
extends AbstractSheetReader<List<Map<String, Object>>> {
    private final int headerRowIndex;

    public MapSheetReader(int headerRowIndex, int startRowIndex, int endRowIndex) {
        super(startRowIndex, endRowIndex);
        this.headerRowIndex = headerRowIndex;
    }

    @Override
    public List<Map<String, Object>> read(Sheet sheet) {
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum < 0) {
            return ListUtil.empty();
        }
        if (this.headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Header row index {} is lower than first row index {}.", (Object[])new Object[]{this.headerRowIndex, firstRowNum}));
        }
        if (this.headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Header row index {} is greater than last row index {}.", (Object[])new Object[]{this.headerRowIndex, lastRowNum}));
        }
        if (this.startRowIndex > lastRowNum) {
            return ListUtil.empty();
        }
        int startRowIndex = Math.max(this.startRowIndex, firstRowNum);
        int endRowIndex = Math.min(this.endRowIndex, lastRowNum);
        List<String> headerList = this.aliasHeader(this.readRow(sheet, this.headerRowIndex));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(endRowIndex - startRowIndex + 1);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList;
            if (i == this.headerRowIndex || !CollUtil.isNotEmpty(rowList = this.readRow(sheet, i)) && this.ignoreEmptyRow) continue;
            result.add(IterUtil.toMap(headerList, rowList, (boolean)true));
        }
        return result;
    }
}

