/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel;

import java.util.Collection;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.multi.ListValueMap;
import org.dromara.hutool.core.text.StrUtil;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class ExcelPicUtil {
    public static ListValueMap<String, PictureData> getPicMap(Workbook workbook, int sheetIndex) {
        Assert.notNull((Object)workbook, (String)"Workbook must be not null !", (Object[])new Object[0]);
        if (sheetIndex < 0) {
            sheetIndex = 0;
        }
        if (workbook instanceof HSSFWorkbook) {
            return ExcelPicUtil.getPicMapXls((HSSFWorkbook)workbook, sheetIndex);
        }
        if (workbook instanceof XSSFWorkbook) {
            return ExcelPicUtil.getPicMapXlsx((XSSFWorkbook)workbook, sheetIndex);
        }
        throw new IllegalArgumentException(StrUtil.format((CharSequence)"Workbook type [{}] is not supported!", (Object[])new Object[]{workbook.getClass()}));
    }

    private static ListValueMap<String, PictureData> getPicMapXls(HSSFWorkbook workbook, int sheetIndex) {
        ListValueMap picMap = new ListValueMap();
        List pictures = workbook.getAllPictures();
        if (CollUtil.isNotEmpty((Collection)pictures)) {
            HSSFSheet sheet = workbook.getSheetAt(sheetIndex);
            for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
                if (!(shape instanceof HSSFPicture)) continue;
                int pictureIndex = ((HSSFPicture)shape).getPictureIndex() - 1;
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                picMap.putValue((Object)StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{anchor.getRow1(), anchor.getCol1()}), pictures.get(pictureIndex));
            }
        }
        return picMap;
    }

    private static ListValueMap<String, PictureData> getPicMapXlsx(XSSFWorkbook workbook, int sheetIndex) {
        ListValueMap sheetIndexPicMap = new ListValueMap();
        XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                if (!(shape instanceof XSSFPicture)) continue;
                XSSFPicture pic = (XSSFPicture)shape;
                CTMarker ctMarker = pic.getPreferredSize().getFrom();
                sheetIndexPicMap.putValue((Object)StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{ctMarker.getRow(), ctMarker.getCol()}), (Object)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }
}

