/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.cell.setters;

import java.io.File;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.poi.excel.ExcelImgType;
import org.dromara.hutool.poi.excel.ExcelImgUtil;
import org.dromara.hutool.poi.excel.SimpleClientAnchor;
import org.dromara.hutool.poi.excel.cell.setters.CellSetter;
import org.dromara.hutool.poi.excel.writer.ExcelDrawingUtil;

public class ImgCellSetter
implements CellSetter {
    private final byte[] pictureData;
    private final ExcelImgType imgType;

    public ImgCellSetter(byte[] pictureData) {
        this(pictureData, ExcelImgType.PNG);
    }

    public ImgCellSetter(File picturefile) {
        this(FileUtil.readBytes((File)picturefile), ExcelImgUtil.getImgType(picturefile));
    }

    public ImgCellSetter(byte[] pictureData, ExcelImgType imgType) {
        this.pictureData = pictureData;
        this.imgType = imgType;
    }

    @Override
    public void setValue(Cell cell) {
        Sheet sheet = cell.getSheet();
        int columnIndex = cell.getColumnIndex();
        int rowIndex = cell.getRowIndex();
        ExcelDrawingUtil.drawingImg(sheet, this.pictureData, this.imgType, new SimpleClientAnchor(columnIndex, rowIndex, columnIndex + 1, rowIndex + 1));
    }
}

