/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.sax.handler;

import java.util.List;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.iter.IterUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.poi.excel.sax.handler.AbstractRowHandler;

public abstract class BeanRowHandler<T>
extends AbstractRowHandler<T> {
    private final int headerRowIndex;
    List<String> headerList;

    public BeanRowHandler(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> clazz) {
        super(startRowIndex, endRowIndex);
        Assert.isTrue((headerRowIndex <= startRowIndex ? 1 : 0) != 0, (String)"Header row must before the start row!", (Object[])new Object[0]);
        this.headerRowIndex = headerRowIndex;
        this.convertFunc = rowList -> BeanUtil.toBean((Object)IterUtil.toMap(this.headerList, (Iterable)rowList), (Class)clazz);
    }

    @Override
    public void handle(int sheetIndex, long rowIndex, List<Object> rowCells) {
        if (rowIndex == (long)this.headerRowIndex) {
            this.headerList = ListUtil.view((List)ConvertUtil.toList(String.class, rowCells));
            return;
        }
        super.handle(sheetIndex, rowIndex, rowCells);
    }
}

