/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.ofd;

import java.io.IOException;
import java.nio.file.Path;
import org.dromara.hutool.core.io.IORuntimeException;
import org.ofdrw.converter.export.HTMLExporter;
import org.ofdrw.converter.export.ImageExporter;
import org.ofdrw.converter.export.PDFExporterIText;
import org.ofdrw.converter.export.PDFExporterPDFBox;
import org.ofdrw.converter.export.SVGExporter;
import org.ofdrw.converter.export.TextExporter;
import org.ofdrw.converter.ofdconverter.ImageConverter;
import org.ofdrw.converter.ofdconverter.PDFConverter;
import org.ofdrw.converter.ofdconverter.TextConverter;

public class DocConverterUtil {
    public static void pdfToOfd(Path src, Path target, int ... pages) {
        try (PDFConverter converter = new PDFConverter(target);){
            converter.convert(src, pages);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void textToOfd(Path src, Path target, double fontSize) {
        try (TextConverter converter = new TextConverter(target);){
            converter.setFontSize(fontSize);
            converter.convert(src, new int[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void imgToOfd(Path target, Path ... images) {
        try (ImageConverter converter = new ImageConverter(target);){
            for (Path image : images) {
                converter.convert(image, new int[0]);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void odfToImage(Path src, Path targetDir, String imgType, double ppm) {
        if ("svg".equalsIgnoreCase(imgType)) {
            DocConverterUtil.odfToSvg(src, targetDir, ppm);
        }
        try (ImageExporter exporter = new ImageExporter(src, targetDir, imgType, ppm);){
            exporter.export(new int[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void odfToHtml(Path src, Path targetPath) {
        try (HTMLExporter exporter = new HTMLExporter(src, targetPath);){
            exporter.export(new int[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void odfToText(Path src, Path targetPath) {
        try (TextExporter exporter = new TextExporter(src, targetPath);){
            exporter.export(new int[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void odfToPdf(Path src, Path targetPath) {
        try (PDFExporterPDFBox exporter = new PDFExporterPDFBox(src, targetPath);){
            exporter.export(new int[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        catch (Exception e) {
            try (PDFExporterIText exporter2 = new PDFExporterIText(src, targetPath);){
                exporter2.export(new int[0]);
            }
            catch (IOException e2) {
                throw new IORuntimeException((Throwable)e);
            }
        }
    }

    private static void odfToSvg(Path src, Path targetDir, double ppm) {
        try (SVGExporter exporter = new SVGExporter(src, targetDir, ppm);){
            exporter.export(new int[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }
}

