/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.csv;

import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dromara.hutool.core.func.SerConsumer;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.PathUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.poi.csv.CsvData;
import org.dromara.hutool.poi.csv.CsvParser;
import org.dromara.hutool.poi.csv.CsvReadConfig;
import org.dromara.hutool.poi.csv.CsvRow;

public class CsvBaseReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;
    private final CsvReadConfig config;

    public CsvBaseReader() {
        this(null);
    }

    public CsvBaseReader(CsvReadConfig config) {
        this.config = (CsvReadConfig)ObjUtil.defaultIfNull((Object)config, CsvReadConfig::defaultConfig);
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.config.setFieldSeparator(fieldSeparator);
    }

    public void setTextDelimiter(char textDelimiter) {
        this.config.setTextDelimiter(textDelimiter);
    }

    public void setContainsHeader(boolean containsHeader) {
        this.config.setContainsHeader(containsHeader);
    }

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.config.setSkipEmptyRows(skipEmptyRows);
    }

    public void setErrorOnDifferentFieldCount(boolean errorOnDifferentFieldCount) {
        this.config.setErrorOnDifferentFieldCount(errorOnDifferentFieldCount);
    }

    public CsvData read(File file) throws IORuntimeException {
        return this.read(file, DEFAULT_CHARSET);
    }

    public CsvData readFromStr(String csvStr) {
        return this.read(new StringReader(csvStr), true);
    }

    public void readFromStr(String csvStr, SerConsumer<CsvRow> rowHandler) {
        this.read(this.parse(new StringReader(csvStr)), true, rowHandler);
    }

    public CsvData read(File file, Charset charset) throws IORuntimeException {
        return this.read(Objects.requireNonNull(file.toPath(), "file must not be null"), charset);
    }

    public CsvData read(Path path) throws IORuntimeException {
        return this.read(path, DEFAULT_CHARSET);
    }

    public CsvData read(Path path, Charset charset) throws IORuntimeException {
        Assert.notNull((Object)path, (String)"path must not be null", (Object[])new Object[0]);
        return this.read(PathUtil.getReader((Path)path, (Charset)charset), true);
    }

    public CsvData read(Reader reader, boolean closeReader) throws IORuntimeException {
        CsvParser csvParser = this.parse(reader);
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        this.read(csvParser, closeReader, (SerConsumer<CsvRow>)((SerConsumer & Serializable)rows::add));
        List<String> header = this.config.headerLineNo > -1L ? csvParser.getHeader() : null;
        return new CsvData(header, rows);
    }

    public List<Map<String, String>> readMapList(Reader reader, boolean closeReader) throws IORuntimeException {
        this.config.setContainsHeader(true);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        this.read(reader, closeReader, (SerConsumer<CsvRow>)(SerConsumer & Serializable)row -> result.add(row.getFieldMap()));
        return result;
    }

    public <T> List<T> read(Reader reader, boolean closeReader, Class<T> clazz) {
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read(reader, closeReader, (SerConsumer<CsvRow>)(SerConsumer & Serializable)row -> result.add(row.toBean(clazz)));
        return result;
    }

    public <T> List<T> read(String csvStr, Class<T> clazz) {
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read((Reader)new StringReader(csvStr), true, (SerConsumer<CsvRow>)(SerConsumer & Serializable)row -> result.add(row.toBean(clazz)));
        return result;
    }

    public void read(Reader reader, boolean closeReader, SerConsumer<CsvRow> rowHandler) throws IORuntimeException {
        this.read(this.parse(reader), closeReader, rowHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void read(CsvParser csvParser, boolean closeParser, SerConsumer<CsvRow> rowHandler) throws IORuntimeException {
        try {
            while (csvParser.hasNext()) {
                rowHandler.accept(csvParser.next());
            }
            if (!closeParser) return;
        }
        catch (Throwable throwable) {
            if (!closeParser) throw throwable;
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{csvParser});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{csvParser});
    }

    protected CsvParser parse(Reader reader) throws IORuntimeException {
        return new CsvParser(reader, this.config);
    }
}

