/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.poi.excel.cell.CellReferenceUtil;
import org.dromara.hutool.poi.excel.cell.editors.CellEditor;

public class ExcelConfig {
    protected Map<String, String> headerAlias;
    protected CellEditor cellEditor;

    public Map<String, String> getHeaderAlias() {
        return this.headerAlias;
    }

    public ExcelConfig setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelConfig addHeaderAlias(String header, String alias) {
        Map<String, String> headerAlias = this.headerAlias;
        if (null == headerAlias) {
            this.headerAlias = headerAlias = new LinkedHashMap<String, String>();
        }
        headerAlias.put(header, alias);
        return this;
    }

    public ExcelConfig removeHeaderAlias(String header) {
        this.headerAlias.remove(header);
        return this;
    }

    public ExcelConfig clearHeaderAlias() {
        return this.setHeaderAlias(null);
    }

    public List<Object> aliasHeader(List<Object> headerList) {
        if (CollUtil.isEmpty(headerList)) {
            return new ArrayList<Object>(0);
        }
        int size = headerList.size();
        ArrayList<Object> result = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            result.add(this.aliasHeader(headerList.get(i), i));
        }
        return result;
    }

    public Object aliasHeader(Object headerObj, int index) {
        if (null == headerObj) {
            return CellReferenceUtil.indexToColName(index);
        }
        if (null != this.headerAlias) {
            return ObjUtil.defaultIfNull((Object)this.headerAlias.get(headerObj.toString()), (Object)headerObj);
        }
        return headerObj;
    }

    public CellEditor getCellEditor() {
        return this.cellEditor;
    }

    public ExcelConfig setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
        return this;
    }
}

