/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.cell;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class CellRangeUtil {
    public static CellRangeAddress of(String ref) {
        return CellRangeAddress.valueOf((String)ref);
    }

    public static CellRangeAddress of(int firstRow, int lastRow, int firstCol, int lastCol) {
        return new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
    }

    public static CellRangeAddress ofSingleRow(int row, int lastCol) {
        return CellRangeUtil.ofSingleRow(row, 0, lastCol);
    }

    public static CellRangeAddress ofSingleRow(int row, int firstCol, int lastCol) {
        return CellRangeUtil.of(row, row, firstCol, lastCol);
    }

    public static CellRangeAddress ofSingleColumn(int lastRow, int col) {
        return CellRangeUtil.ofSingleColumn(0, lastRow, col);
    }

    public static CellRangeAddress ofSingleColumn(int firstRow, int lastRow, int col) {
        return CellRangeUtil.of(firstRow, lastRow, col, col);
    }

    public static CellRangeAddress getCellRangeAddress(Sheet sheet, String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return CellRangeUtil.getCellRangeAddress(sheet, cellReference.getCol(), cellReference.getRow());
    }

    public static CellRangeAddress getCellRangeAddress(Cell cell) {
        return CellRangeUtil.getCellRangeAddress(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static CellRangeAddress getCellRangeAddress(Sheet sheet, int x, int y) {
        if (sheet != null) {
            int sheetMergeCount = sheet.getNumMergedRegions();
            for (int i = 0; i < sheetMergeCount; ++i) {
                CellRangeAddress ca = sheet.getMergedRegion(i);
                if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
                return ca;
            }
        }
        return null;
    }
}

