/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.reader.sheet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.iter.IterUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.poi.excel.RowUtil;
import org.dromara.hutool.poi.excel.reader.sheet.AbstractSheetReader;

public class MapSheetReader
extends AbstractSheetReader<List<Map<Object, Object>>> {
    private final int headerRowIndex;

    public MapSheetReader(int headerRowIndex, int startRowIndex, int endRowIndex) {
        super(startRowIndex, endRowIndex);
        this.headerRowIndex = headerRowIndex;
    }

    @Override
    public List<Map<Object, Object>> read(Sheet sheet) {
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum < 0) {
            return ListUtil.empty();
        }
        if (this.headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Header row index {} is lower than first row index {}.", (Object[])new Object[]{this.headerRowIndex, firstRowNum}));
        }
        if (this.headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Header row index {} is greater than last row index {}.", (Object[])new Object[]{this.headerRowIndex, lastRowNum}));
        }
        int startRowIndex = this.cellRangeAddress.getFirstRow();
        if (startRowIndex > lastRowNum) {
            return ListUtil.empty();
        }
        startRowIndex = Math.max(startRowIndex, firstRowNum);
        int endRowIndex = Math.min(this.cellRangeAddress.getLastRow(), lastRowNum);
        List<Object> headerList = this.config.aliasHeader(this.readRow(sheet, this.headerRowIndex));
        ArrayList<Map<Object, Object>> result = new ArrayList<Map<Object, Object>>(endRowIndex - startRowIndex + 1);
        boolean ignoreEmptyRow = this.config.isIgnoreEmptyRow();
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList;
            if (i == this.headerRowIndex || !CollUtil.isNotEmpty(rowList = this.readRow(sheet, i)) && ignoreEmptyRow) continue;
            result.add(IterUtil.toMap(headerList, rowList, (boolean)true));
        }
        return result;
    }

    private List<Object> readRow(Sheet sheet, int rowIndex) {
        return RowUtil.readRow(sheet.getRow(rowIndex), this.config.getCellEditor());
    }
}

