/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.sax;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.poi.POIException;
import org.dromara.hutool.poi.excel.sax.ExcelSaxUtil;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SheetRidReader
extends DefaultHandler {
    private static final String TAG_NAME = "sheet";
    private static final String RID_ATTR = "r:id";
    private static final String SHEET_ID_ATTR = "sheetId";
    private static final String NAME_ATTR = "name";
    private final Map<Integer, Integer> ID_RID_MAP = new LinkedHashMap<Integer, Integer>();
    private final Map<String, Integer> NAME_RID_MAP = new LinkedHashMap<String, Integer>();

    public static SheetRidReader parse(XSSFReader reader) {
        return new SheetRidReader().read(reader);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SheetRidReader read(XSSFReader xssfReader) {
        InputStream workbookData = null;
        try {
            workbookData = xssfReader.getWorkbookData();
            ExcelSaxUtil.readFrom(workbookData, this);
        }
        catch (InvalidFormatException e) {
            try {
                throw new POIException(e);
                catch (IOException e2) {
                    throw new IORuntimeException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{workbookData});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{workbookData});
        return this;
    }

    public Integer getRidBySheetId(int sheetId) {
        return this.ID_RID_MAP.get(sheetId);
    }

    public Integer getRidBySheetIdBase0(int sheetId) {
        Integer rid = this.getRidBySheetId(sheetId + 1);
        if (null != rid) {
            return rid - 1;
        }
        return null;
    }

    public Integer getRidByName(String sheetName) {
        return this.NAME_RID_MAP.get(sheetName);
    }

    public Integer getRidByNameBase0(String sheetName) {
        Integer rid = this.getRidByName(sheetName);
        if (null != rid) {
            return rid - 1;
        }
        return null;
    }

    public Integer getRidByIndex(int index) {
        return (Integer)CollUtil.get(this.NAME_RID_MAP.values(), (int)index);
    }

    public Integer getRidByIndexBase0(int index) {
        Integer rid = (Integer)CollUtil.get(this.NAME_RID_MAP.values(), (int)index);
        if (null != rid) {
            return rid - 1;
        }
        return null;
    }

    public List<String> getSheetNames() {
        return ListUtil.of(this.NAME_RID_MAP.keySet());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (TAG_NAME.equalsIgnoreCase(localName)) {
            String sheetIdStr;
            String ridStr = attributes.getValue(RID_ATTR);
            if (StrUtil.isEmpty((CharSequence)ridStr)) {
                return;
            }
            int rid = Integer.parseInt(StrUtil.removePrefixIgnoreCase((CharSequence)ridStr, (CharSequence)"rId"));
            String name = attributes.getValue(NAME_ATTR);
            if (StrUtil.isNotEmpty((CharSequence)name)) {
                this.NAME_RID_MAP.put(name, rid);
            }
            if (StrUtil.isNotEmpty((CharSequence)(sheetIdStr = attributes.getValue(SHEET_ID_ATTR)))) {
                this.ID_RID_MAP.put(Integer.parseInt(sheetIdStr), rid);
            }
        }
    }
}

