/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.reader;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.extractor.ExcelExtractor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.dromara.hutool.core.func.SerBiConsumer;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.poi.excel.ExcelBase;
import org.dromara.hutool.poi.excel.ExcelExtractorUtil;
import org.dromara.hutool.poi.excel.ExcelUtil;
import org.dromara.hutool.poi.excel.RowUtil;
import org.dromara.hutool.poi.excel.WorkbookUtil;
import org.dromara.hutool.poi.excel.cell.CellUtil;
import org.dromara.hutool.poi.excel.reader.ExcelReadConfig;
import org.dromara.hutool.poi.excel.reader.sheet.BeanSheetReader;
import org.dromara.hutool.poi.excel.reader.sheet.ColumnSheetReader;
import org.dromara.hutool.poi.excel.reader.sheet.ListSheetReader;
import org.dromara.hutool.poi.excel.reader.sheet.MapSheetReader;
import org.dromara.hutool.poi.excel.reader.sheet.SheetReader;
import org.dromara.hutool.poi.excel.reader.sheet.WalkSheetReader;
import org.dromara.hutool.poi.excel.shape.ExcelPicUtil;
import org.dromara.hutool.poi.excel.writer.ExcelWriter;

public class ExcelReader
extends ExcelBase<ExcelReader, ExcelReadConfig> {
    public ExcelReader(String excelFilePath, int sheetIndex) {
        this(FileUtil.file((String)excelFilePath), sheetIndex);
    }

    public ExcelReader(String excelFilePath, String sheetName) {
        this(FileUtil.file((String)excelFilePath), sheetName);
    }

    public ExcelReader(File bookFile, int sheetIndex) {
        this(WorkbookUtil.createBook(bookFile, true), sheetIndex);
        this.targetFile = bookFile;
    }

    public ExcelReader(File bookFile, String sheetName) {
        this(WorkbookUtil.createBook(bookFile, true), sheetName);
        this.targetFile = bookFile;
    }

    public ExcelReader(InputStream bookStream, int sheetIndex) {
        this(WorkbookUtil.createBook(bookStream), sheetIndex);
    }

    public ExcelReader(InputStream bookStream, String sheetName) {
        this(WorkbookUtil.createBook(bookStream), sheetName);
    }

    public ExcelReader(Workbook book, int sheetIndex) {
        this(ExcelReader.getSheetOrCloseWorkbook(book, sheetIndex));
    }

    public ExcelReader(Workbook book, String sheetName) {
        this(ExcelReader.getSheetOrCloseWorkbook(book, sheetName));
    }

    public ExcelReader(Sheet sheet) {
        super(new ExcelReadConfig(), sheet);
    }

    public List<List<Object>> read() {
        return this.read(0);
    }

    public List<List<Object>> read(int startRowIndex) {
        return this.read(startRowIndex, Integer.MAX_VALUE);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex) {
        return this.read(startRowIndex, endRowIndex, false);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex, boolean aliasFirstLine) {
        ListSheetReader reader = new ListSheetReader(startRowIndex, endRowIndex, aliasFirstLine);
        reader.setExcelConfig((ExcelReadConfig)this.config);
        return this.read(reader);
    }

    public List<Object> readColumn(int columnIndex, int startRowIndex) {
        return this.readColumn(columnIndex, startRowIndex, Integer.MAX_VALUE);
    }

    public List<Object> readColumn(int columnIndex, int startRowIndex, int endRowIndex) {
        ColumnSheetReader reader = new ColumnSheetReader(columnIndex, startRowIndex, endRowIndex);
        reader.setExcelConfig((ExcelReadConfig)this.config);
        return this.read(reader);
    }

    public void read(SerBiConsumer<Cell, Object> cellHandler) {
        this.read(0, Integer.MAX_VALUE, cellHandler);
    }

    public void read(int startRowIndex, int endRowIndex, SerBiConsumer<Cell, Object> cellHandler) {
        this.checkClosed();
        WalkSheetReader reader = new WalkSheetReader(startRowIndex, endRowIndex, cellHandler);
        reader.setExcelConfig((ExcelReadConfig)this.config);
        reader.read(this.sheet);
    }

    public List<Map<Object, Object>> readAll() {
        return this.read(0, 1, Integer.MAX_VALUE);
    }

    public List<Map<Object, Object>> read(int headerRowIndex, int startRowIndex, int endRowIndex) {
        MapSheetReader reader = new MapSheetReader(headerRowIndex, startRowIndex, endRowIndex);
        reader.setExcelConfig((ExcelReadConfig)this.config);
        return this.read(reader);
    }

    public <T> List<T> readAll(Class<T> beanType) {
        return this.read(0, 1, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, Class<T> beanType) {
        return this.read(headerRowIndex, startRowIndex, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanType) {
        BeanSheetReader<T> reader = new BeanSheetReader<T>(headerRowIndex, startRowIndex, endRowIndex, beanType);
        reader.setExcelConfig((ExcelReadConfig)this.config);
        return (List)this.read(reader);
    }

    public <T> T read(SheetReader<T> sheetReader) {
        this.checkClosed();
        return ((SheetReader)Assert.notNull(sheetReader)).read(this.sheet);
    }

    public String readAsText(boolean withSheetName) {
        return ExcelExtractorUtil.readAsText(this.workbook, withSheetName);
    }

    public ExcelExtractor getExtractor() {
        return ExcelExtractorUtil.getExtractor(this.workbook);
    }

    public List<Object> readRow(int rowIndex) {
        return this.readRow(this.sheet.getRow(rowIndex));
    }

    public Object readCellValue(int x, int y) {
        return CellUtil.getCellValue(this.getCell(x, y), ((ExcelReadConfig)this.config).getCellEditor());
    }

    public List<Picture> readPics() {
        return ExcelPicUtil.getShapePics(this.sheet);
    }

    public ExcelWriter getWriter() {
        if (null == this.targetFile) {
            return new ExcelWriter(this.sheet);
        }
        return ExcelUtil.getWriter(this.targetFile, this.sheet.getSheetName());
    }

    private List<Object> readRow(Row row) {
        return RowUtil.readRow(row, ((ExcelReadConfig)this.config).getCellEditor());
    }

    private static Sheet getSheetOrCloseWorkbook(Workbook workbook, String name) throws IllegalArgumentException {
        Sheet sheet;
        Assert.notNull((Object)workbook);
        if (null == name) {
            name = "sheet1";
        }
        if (null == (sheet = workbook.getSheet(name))) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{workbook});
            throw new IllegalArgumentException("Sheet [" + name + "] not exist!");
        }
        return sheet;
    }

    private static Sheet getSheetOrCloseWorkbook(Workbook workbook, int sheetIndex) throws IllegalArgumentException {
        Sheet sheet;
        Assert.notNull((Object)workbook);
        try {
            sheet = workbook.getSheetAt(sheetIndex);
        }
        catch (IllegalArgumentException e) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{workbook});
            throw e;
        }
        if (null == sheet) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{workbook});
            throw new IllegalArgumentException("Sheet at [" + sheetIndex + "] not exist!");
        }
        return sheet;
    }
}

