/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.writer;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.common.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.multi.Table;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.poi.excel.RowGroup;
import org.dromara.hutool.poi.excel.RowUtil;
import org.dromara.hutool.poi.excel.cell.CellRangeUtil;
import org.dromara.hutool.poi.excel.cell.CellUtil;
import org.dromara.hutool.poi.excel.cell.editors.CellEditor;
import org.dromara.hutool.poi.excel.style.StyleSet;
import org.dromara.hutool.poi.excel.writer.ExcelWriteConfig;

public class SheetDataWriter {
    private final Sheet sheet;
    private final ExcelWriteConfig config;
    private StyleSet styleSet;
    private Map<String, Integer> headerLocationCache;
    private final AtomicInteger currentRow;

    public SheetDataWriter(Sheet sheet, ExcelWriteConfig config, StyleSet styleSet) {
        this.sheet = sheet;
        this.config = config;
        this.styleSet = styleSet;
        this.currentRow = new AtomicInteger(0);
    }

    public SheetDataWriter setStyleSet(StyleSet styleSet) {
        this.styleSet = styleSet;
        return this;
    }

    public SheetDataWriter setHeaderLocationCache(Map<String, Integer> headerLocationCache) {
        this.headerLocationCache = headerLocationCache;
        return this;
    }

    public SheetDataWriter writeHeader(int x, int y, int rowCount, RowGroup rowGroup) {
        int childrenMaxRowCount;
        String name = rowGroup.getName();
        List<RowGroup> children = rowGroup.getChildren();
        if (null != name) {
            if (CollUtil.isNotEmpty(children)) {
                rowCount = Math.max(1, rowCount - rowGroup.childrenMaxRowCount());
            }
            CellRangeAddress cellRangeAddresses = CellRangeUtil.of(y, y + rowCount - 1, x, x + rowGroup.maxColumnCount() - 1);
            CellStyle style = rowGroup.getStyle();
            if (null == style && null != this.styleSet) {
                style = this.styleSet.getStyleFor(new CellReference(cellRangeAddresses.getFirstRow(), cellRangeAddresses.getFirstColumn()), name, true);
            }
            CellUtil.mergingCells(this.sheet, cellRangeAddresses, style);
            Cell cell = CellUtil.getOrCreateCell(this.sheet, cellRangeAddresses.getFirstColumn(), cellRangeAddresses.getFirstRow());
            if (null != cell) {
                CellUtil.setCellValue(cell, name, style, this.config.getCellEditor());
            }
            y += rowCount;
        }
        if ((childrenMaxRowCount = rowGroup.childrenMaxRowCount()) > 0) {
            for (RowGroup child : children) {
                this.writeHeader(x, y, childrenMaxRowCount, child);
                x += child.maxColumnCount();
            }
        }
        return this;
    }

    public SheetDataWriter writeRow(Object rowBean, boolean isWriteKeyAsHead) {
        Map rowMap;
        ExcelWriteConfig config = this.config;
        if (rowBean instanceof Map) {
            rowMap = MapUtil.isNotEmpty(config.getHeaderAlias()) ? MapUtil.newTreeMap((Map)((Map)rowBean), config.getCachedAliasComparator()) : (Map)rowBean;
        } else {
            if (rowBean instanceof Iterable) {
                return this.writeRow((Iterable)rowBean);
            }
            if (rowBean instanceof Hyperlink) {
                return this.writeRow(ListUtil.of((Object[])new Object[]{rowBean}), isWriteKeyAsHead);
            }
            if (BeanUtil.isReadableBean(rowBean.getClass())) {
                rowMap = MapUtil.isEmpty(config.getHeaderAlias()) ? BeanUtil.beanToMap((Object)rowBean, new LinkedHashMap(), (boolean)false, (boolean)false) : BeanUtil.beanToMap((Object)rowBean, new TreeMap(config.getCachedAliasComparator()), (boolean)false, (boolean)false);
            } else {
                return this.writeRow(ListUtil.of((Object[])new Object[]{rowBean}), isWriteKeyAsHead);
            }
        }
        return this.writeRow(rowMap, isWriteKeyAsHead);
    }

    public SheetDataWriter writeRow(Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        if (MapUtil.isEmpty(rowMap)) {
            this.passAndGet();
            return this;
        }
        Table<?, ?, ?> aliasTable = this.config.aliasTable(rowMap);
        if (isWriteKeyAsHead) {
            this.writeHeaderRow(aliasTable.columnKeys());
            int i = 0;
            for (Object key : aliasTable.rowKeySet()) {
                this.headerLocationCache.putIfAbsent(StrUtil.toString(key), i);
                ++i;
            }
        }
        if (MapUtil.isNotEmpty(this.headerLocationCache)) {
            Row row = RowUtil.getOrCreateRow(this.sheet, this.currentRow.getAndIncrement());
            CellEditor cellEditor = this.config.getCellEditor();
            for (Table.Cell cell : aliasTable) {
                Integer columnIndex = this.getColumnIndex(cell);
                if (null == columnIndex) continue;
                CellUtil.setCellValue(CellUtil.getOrCreateCell(row, columnIndex), cell.getValue(), this.styleSet, false, cellEditor);
            }
        } else {
            this.writeRow(aliasTable.values());
        }
        return this;
    }

    public SheetDataWriter writeHeaderRow(Iterable<?> rowData) {
        int rowNum = this.currentRow.getAndIncrement();
        Row row = this.config.insertRow ? this.sheet.createRow(rowNum) : RowUtil.getOrCreateRow(this.sheet, rowNum);
        LinkedHashMap<String, Integer> headerLocationCache = new LinkedHashMap<String, Integer>();
        CellEditor cellEditor = this.config.getCellEditor();
        int i = 0;
        for (Object value : rowData) {
            Cell cell = CellUtil.getOrCreateCell(row, i);
            CellUtil.setCellValue(cell, value, this.styleSet, true, cellEditor);
            headerLocationCache.put(StrUtil.toString(value), i);
            ++i;
        }
        return this.setHeaderLocationCache(headerLocationCache);
    }

    public SheetDataWriter writeRow(Iterable<?> rowData) {
        int rowNum = this.currentRow.getAndIncrement();
        Row row = this.config.insertRow ? this.sheet.createRow(rowNum) : RowUtil.getOrCreateRow(this.sheet, rowNum);
        RowUtil.writeRow(row, rowData, this.styleSet, false, this.config.getCellEditor());
        return this;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    public SheetDataWriter setCurrentRow(int rowIndex) {
        this.currentRow.set(rowIndex);
        return this;
    }

    public int passAndGet() {
        return this.currentRow.incrementAndGet();
    }

    public int passRowsAndGet(int rowNum) {
        return this.currentRow.addAndGet(rowNum);
    }

    public SheetDataWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    private Integer getColumnIndex(Table.Cell<?, ?, ?> cell) {
        Integer location = this.headerLocationCache.get(StrUtil.toString((Object)cell.getRowKey()));
        if (null == location) {
            location = this.headerLocationCache.get(StrUtil.toString((Object)cell.getColumnKey()));
        }
        return location;
    }
}

