/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.writer;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.poi.excel.SheetUtil;
import org.dromara.hutool.poi.excel.cell.CellUtil;
import org.dromara.hutool.poi.excel.cell.VirtualCell;

public class TemplateContext {
    private static final String VAR_PREFIX = "{";
    private static final String VAR_SUFFIX = "}";
    private static final Pattern VAR_PATTERN = Pattern.compile("(?<!\\\\)\\{([.$_a-zA-Z]+\\d*[.$_a-zA-Z]*)}");
    private static final Pattern ESCAPE_VAR_PATTERN = Pattern.compile("\\\\\\{([.$_a-zA-Z]+\\d*[.$_a-zA-Z]*)\\\\}");
    private final Map<String, Cell> varMap = new LinkedHashMap<String, Cell>();

    public TemplateContext(Sheet templateSheet) {
        this.init(templateSheet);
    }

    public Cell getCell(String varName) {
        return this.varMap.get(varName);
    }

    public int getBottomRowIndex(Object rowDataBean) {
        AtomicInteger bottomRowIndex = new AtomicInteger(-1);
        this.varMap.forEach((name, cell) -> {
            if (null != BeanUtil.getProperty((Object)rowDataBean, (String)name)) {
                if (cell instanceof VirtualCell) {
                    bottomRowIndex.set(Math.max(bottomRowIndex.get(), cell.getRowIndex()));
                } else if (bottomRowIndex.get() < 0) {
                    bottomRowIndex.set(0);
                }
            }
        });
        return bottomRowIndex.get();
    }

    public void fill(Object rowDataBean, boolean isListVar) {
        Map<String, Cell> varMap = this.varMap;
        varMap.forEach((name, cell) -> {
            if (null == cell) {
                return;
            }
            String templateStr = cell.getStringCellValue();
            if (this.fill((Cell)cell, (String)name, rowDataBean)) {
                this.putNext((String)name, (Cell)cell, templateStr, isListVar);
            }
        });
        if (!isListVar) {
            MapUtil.removeNullValue(varMap);
        }
    }

    private void putNext(String name, Cell currentCell, String templateStr, boolean isListVar) {
        if (isListVar) {
            VirtualCell next = new VirtualCell(currentCell, currentCell.getColumnIndex(), currentCell.getRowIndex() + 1, templateStr);
            this.varMap.put(name, (Cell)next);
        } else {
            this.varMap.put(name, null);
        }
    }

    private boolean fill(Cell cell, String name, Object rowDataBean) {
        Object cellValue;
        String templateStr = cell.getStringCellValue();
        if (cell instanceof VirtualCell) {
            Cell newCell = CellUtil.getCell(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex(), true);
            Assert.notNull((Object)newCell, (String)"Can not get or create cell at {},{}", (Object[])new Object[]{cell.getColumnIndex(), cell.getRowIndex()});
            newCell.setCellStyle(cell.getCellStyle());
            cell = newCell;
        }
        if (StrUtil.equals((CharSequence)name, (CharSequence)StrUtil.unWrap((CharSequence)templateStr, (String)VAR_PREFIX, (String)VAR_SUFFIX)) ? null == (cellValue = BeanUtil.getProperty((Object)rowDataBean, (String)name)) : ObjUtil.equals((Object)(cellValue = StrUtil.formatByBean((CharSequence)templateStr, (Object)rowDataBean, (boolean)true)), (Object)templateStr)) {
            return false;
        }
        CellUtil.setCellValue(cell, cellValue);
        return true;
    }

    private void init(Sheet templateSheet) {
        SheetUtil.walk(templateSheet, (cell, ctx) -> {
            if (CellType.STRING == cell.getCellType()) {
                String str;
                String cellValue = cell.getStringCellValue();
                List vars = ReUtil.findAllGroup1((Pattern)VAR_PATTERN, (CharSequence)cellValue);
                if (CollUtil.isNotEmpty((Collection)vars)) {
                    for (String var : vars) {
                        this.varMap.put(var, cell);
                    }
                }
                if (!StrUtil.equals((CharSequence)cellValue, (CharSequence)(str = ReUtil.replaceAll((CharSequence)cellValue, (Pattern)ESCAPE_VAR_PATTERN, (SerFunction & Serializable)matcher -> VAR_PREFIX + matcher.group(1) + VAR_SUFFIX)))) {
                    cell.setCellValue(str);
                }
            }
        });
    }

    public String toString() {
        return "TemplateContext{varMap=" + this.varMap + '}';
    }
}

