/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.csv;

import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dromara.hutool.core.func.SerConsumer;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.file.PathUtil;
import org.dromara.hutool.poi.csv.CsvBaseReader;
import org.dromara.hutool.poi.csv.CsvData;
import org.dromara.hutool.poi.csv.CsvReadConfig;
import org.dromara.hutool.poi.csv.CsvRow;

public class CsvReader
extends CsvBaseReader
implements Iterable<CsvRow>,
Closeable {
    private static final long serialVersionUID = 1L;
    private final Reader reader;

    public CsvReader() {
        this(null);
    }

    public CsvReader(CsvReadConfig config) {
        this((Reader)null, config);
    }

    public CsvReader(File file, CsvReadConfig config) {
        this(file, DEFAULT_CHARSET, config);
    }

    public CsvReader(Path path, CsvReadConfig config) {
        this(path, DEFAULT_CHARSET, config);
    }

    public CsvReader(File file, Charset charset, CsvReadConfig config) {
        this(FileUtil.getReader((File)file, (Charset)charset), config);
    }

    public CsvReader(Path path, Charset charset, CsvReadConfig config) {
        this(PathUtil.getReader((Path)path, (Charset)charset), config);
    }

    public CsvReader(Reader reader, CsvReadConfig config) {
        super(config);
        this.reader = reader;
    }

    public CsvData read() throws IORuntimeException {
        return this.read(this.reader, false);
    }

    public void read(SerConsumer<CsvRow> rowHandler) throws IORuntimeException {
        this.read(this.reader, false, rowHandler);
    }

    public Stream<CsvRow> stream() {
        return (Stream)StreamSupport.stream(this.spliterator(), false).onClose(this::close);
    }

    @Override
    public Iterator<CsvRow> iterator() {
        return this.parse(this.reader);
    }

    @Override
    public void close() {
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.reader});
    }
}

